/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.ExamClbumMapper;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.ExamQuAnswerMapper;
import com.zsy.exam.mapper.ExaminationPaperMapper;
import com.zsy.exam.mapper.UserExamsScoreMapper;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExamQuAnswer;
import com.zsy.exam.model.entity.UserExamsScore;
import com.zsy.exam.model.form.score.ClassQualityReportQuery;
import com.zsy.exam.model.vo.score.ClbumScoreVO;
import com.zsy.exam.model.vo.score.ExamAnalyzeListVO;
import com.zsy.exam.model.vo.score.UserScoreExcelVO;
import com.zsy.exam.model.vo.score.UserScoreVO;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.IUserExamsScoreService;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserExamsScoreServiceImpl
extends ServiceImpl<UserExamsScoreMapper, UserExamsScore>
implements IUserExamsScoreService {
    @Resource
    private UserExamsScoreMapper userExamsScoreMapper;
    @Resource
    private ExamMapper examMapper;
    @Resource
    private ExamClbumMapper examClbumMapper;
    @Resource
    private ExamQuAnswerMapper examQuAnswerMapper;
    @Resource
    private ExaminationPaperMapper examinationPaperMapper;
    @Resource
    private IRoleService roleService;

    public Result<IPage<UserScoreVO>> pagingScore(Integer pageNum, Integer pageSize, Long clbumId, Long examId, String realName, String studyCode, String realNameOrStudyCode, Boolean isAttend) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        page = this.userExamsScoreMapper.pagingScore((IPage)page, clbumId, examId, realName, studyCode, realNameOrStudyCode, isAttend);
        return Result.success(null, (Object)page);
    }

    public boolean isUserTakingExam(Long examId, Long userId) {
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getUserId, (Object)userId)).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getState, (Object)0);
        List userExamsScores = this.userExamsScoreMapper.selectList((Wrapper)userExamsScoreLambdaQueryWrapper);
        return userExamsScores.size() != 0;
    }

    public Result resetCount(Long scoreId, String reason) {
        UserExamsScore userExamsScore = (UserExamsScore)this.userExamsScoreMapper.selectById((Serializable)scoreId);
        Exam exam = (Exam)this.examMapper.selectById((Serializable)userExamsScore.getExamId());
        LocalDateTime now = LocalDateTime.now();
        if (now.isBefore(exam.getStartTime())) {
            return Result.failed((String)"\u8003\u8bd5\u8fd8\u6ca1\u6709\u5f00\u59cb\u65e0\u6cd5\u91cd\u7f6e");
        }
        if (now.isAfter(exam.getEndTime())) {
            return Result.failed((String)"\u8003\u8bd5\u5df2\u7ecf\u7ed3\u675f\u65e0\u6cd5\u91cd\u7f6e");
        }
        if (!userExamsScore.getIsAttend().booleanValue()) {
            return Result.failed((String)"\u8be5\u8003\u751f\u6ca1\u6709\u53c2\u52a0\u8003\u8bd5\u65e0\u6cd5\u91cd\u7f6e");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(UserExamsScore::getId, (Object)scoreId)).set(UserExamsScore::getCount, (Object)0)).set(UserExamsScore::getState, (Object)0)).set(UserExamsScore::getResetCountReason, (Object)reason);
        int update = this.userExamsScoreMapper.update((Wrapper)updateWrapper);
        if (update > 0) {
            return Result.ok((Object)"\u91cd\u7f6e\u6210\u529f\uff0c\u8be5\u8003\u751f\u53ef\u91cd\u65b0\u53c2\u52a0\u8003\u8bd5");
        }
        return Result.failed((String)"\u91cd\u7f6e\u5931\u8d25");
    }

    public Result setCheater(Long scoreId, String reason) {
        UserExamsScore userExamsScore = (UserExamsScore)this.userExamsScoreMapper.selectById((Serializable)scoreId);
        Exam exam = (Exam)this.examMapper.selectById((Serializable)userExamsScore.getExamId());
        LocalDateTime now = LocalDateTime.now();
        if (now.isBefore(exam.getStartTime())) {
            return Result.failed((String)"\u8003\u8bd5\u8fd8\u6ca1\u6709\u5f00\u59cb\u65e0\u6cd5\u8bbe\u7f6e");
        }
        if (!userExamsScore.getIsAttend().booleanValue()) {
            return Result.failed((String)"\u8be5\u8003\u751f\u6ca1\u6709\u53c2\u52a0\u8003\u8bd5\u65e0\u6cd5\u8bbe\u7f6e");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(UserExamsScore::getId, (Object)scoreId)).set(UserExamsScore::getCount, (Object)(exam.getMaxCount() + 1))).set(UserExamsScore::getState, (Object)1)).set(UserExamsScore::getResetCountReason, (Object)reason);
        int update = this.userExamsScoreMapper.update((Wrapper)updateWrapper);
        if (update > 0) {
            return Result.ok((Object)"\u8bbe\u7f6e\u6210\u529f");
        }
        return null;
    }

    public void exportScores(HttpServletResponse response, Long examId, Long clbumId) {
        Page page = new Page(1L, 100000000000L);
        IPage scores = this.userExamsScoreMapper.pagingScore((IPage)page, clbumId, examId, null, null, null, Boolean.valueOf(true));
        List records = scores.getRecords();
        ArrayList<UserScoreExcelVO> res = new ArrayList<UserScoreExcelVO>();
        for (int i = 1; i <= records.size(); ++i) {
            UserScoreVO userScoreVO = (UserScoreVO)records.get(i - 1);
            userScoreVO.setRanking(Integer.valueOf(i));
            UserScoreExcelVO userScoreExcelVO = new UserScoreExcelVO();
            BeanUtils.copyProperties((Object)userScoreVO, (Object)userScoreExcelVO);
            userScoreExcelVO.setUserTime(Integer.valueOf(userScoreVO.getUserTime() / 60));
            userScoreExcelVO.setIsPassed(userScoreVO.getIsPassed() != false ? "\u662f" : "\u5426");
            userScoreExcelVO.setIsAttend(userScoreVO.getIsAttend() > 0 ? "\u662f" : "\u5426");
            userScoreExcelVO.setLimitTime(userScoreVO.getLimitTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2")));
            res.add(userScoreExcelVO);
        }
        LambdaQueryWrapper wrapper = ((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Exam::getId, (Object)examId)).select(new SFunction[]{Exam::getTitle});
        Exam exam = (Exam)this.examMapper.selectOne((Wrapper)wrapper);
        ExcelUtils.export((HttpServletResponse)response, (String)exam.getTitle(), res, UserScoreExcelVO.class);
    }

    public Result<IPage<ClbumScoreVO>> getExamScoreInfo(Integer pageNum, Integer pageSize, String examTitle, Long clbumId) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        List roles = this.roleService.getCurrentRoles();
        page = roles.contains(RoleEnum.TEACHER.getCode()) ? this.userExamsScoreMapper.scoreStatistics((IPage)page, clbumId, examTitle, SecurityUtil.getUserId(), Long.valueOf(2L)) : this.userExamsScoreMapper.scoreStatistics((IPage)page, clbumId, examTitle, SecurityUtil.getUserId(), Long.valueOf(3L));
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)page);
    }

    public Result<Page<ExamAnalyzeListVO>> pagingExamAnalyzeList(Page page, String title, String startTime, String endTime, String subjectCode) {
        List roles = this.roleService.getCurrentRoles();
        Long userId = null;
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            userId = SecurityUtil.getUserId();
        }
        Page examAnalyzeListVOPage = this.userExamsScoreMapper.pagingExamAnalyzeList(page, title, userId, startTime, endTime, subjectCode);
        List records = examAnalyzeListVOPage.getRecords();
        for (ExamAnalyzeListVO record : records) {
            record.setTotal(Long.valueOf(this.examClbumMapper.selectClassSize(record.getId()).longValue()));
        }
        this.getDistinguishPoint(examAnalyzeListVOPage);
        return Result.success((Object)examAnalyzeListVOPage);
    }

    private void getDistinguishPoint(Page<ExamAnalyzeListVO> vos) {
        List records = vos.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return;
        }
        for (ExamAnalyzeListVO vo : records) {
            List userExamsScores = this.userExamsScoreMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserExamsScore::getExamId, (Object)vo.getId())).eq(UserExamsScore::getIsAttend, (Object)true)).orderByDesc(UserExamsScore::getUserScore));
            if (CollectionUtils.isEmpty((Collection)userExamsScores)) continue;
            double d = 0.27 * (double)userExamsScores.size();
            Long peopleCount = Math.round(d);
            List first = userExamsScores.subList(0, Integer.valueOf(peopleCount.toString()));
            List last = userExamsScores.subList(userExamsScores.size() - Integer.valueOf(peopleCount.toString()), userExamsScores.size());
            List firstUserIds = first.stream().map(UserExamsScore::getUserId).collect(Collectors.toList());
            List lastUserIds = last.stream().map(UserExamsScore::getUserId).collect(Collectors.toList());
            Integer allPeopleCount = firstUserIds.size() + lastUserIds.size();
            if (Integer.valueOf(0).equals(allPeopleCount)) continue;
            List firstAnswers = this.examQuAnswerMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExamQuAnswer::getExamId, (Object)vo.getId())).eq(ExamQuAnswer::getIsRight, (Object)1)).in(ExamQuAnswer::getUserId, firstUserIds));
            List lastAnswers = this.examQuAnswerMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExamQuAnswer::getExamId, (Object)vo.getId())).eq(ExamQuAnswer::getIsRight, (Object)1)).in(ExamQuAnswer::getUserId, lastUserIds));
            Map firstMap = firstAnswers.stream().collect(Collectors.groupingBy(ExamQuAnswer::getQuestionId, Collectors.toList()));
            Map lastMap = lastAnswers.stream().collect(Collectors.groupingBy(ExamQuAnswer::getQuestionId, Collectors.toList()));
            Set collect = this.examinationPaperMapper.getQuestionCountByExamId(vo.getId());
            BigDecimal questionDistinguishPoint = BigDecimal.ZERO;
            Integer count = 0;
            for (Long questionId : collect) {
                List firstList = firstMap.get(questionId);
                List lastList = lastMap.get(questionId);
                Integer firstCount = 0;
                Integer lastCount = 0;
                if (!CollectionUtils.isEmpty(firstList)) {
                    firstCount = firstList.size();
                }
                if (!CollectionUtils.isEmpty(lastList)) {
                    lastCount = lastList.size();
                }
                questionDistinguishPoint = questionDistinguishPoint.add(new BigDecimal(firstCount - lastCount).divide(new BigDecimal(allPeopleCount), 2, RoundingMode.HALF_UP));
                Integer n = count;
                count = count + 1;
            }
            BigDecimal examDistinguishPoint = questionDistinguishPoint.divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
            vo.setExamDistinguishPoint(examDistinguishPoint);
        }
    }

    private void getClassQualityReport(ClassQualityReportQuery query) {
        List classQualityReport = ((UserExamsScoreMapper)this.baseMapper).getClassQualityReport(query);
        classQualityReport.forEach(a -> {
            Integer aLevel = a.getALevel();
            Integer bLevel = a.getBLevel();
            int abLevel = aLevel + bLevel;
            a.setAbLevel(Integer.valueOf(abLevel));
            Integer passedNumber = a.getPassedNumber();
            Double realAttendCount = a.getRealAttendCount();
            if (passedNumber != null && realAttendCount != null && realAttendCount != 0.0) {
                a.setPassingRate(Double.valueOf((double)passedNumber.intValue() / realAttendCount));
            }
        });
    }
}

