/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.UserExerciseReviewMapper;
import com.zsy.exam.model.entity.UserExerciseReview;
import com.zsy.exam.service.IUserExerciseReviewService;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserExerciseReviewServiceImpl
extends ServiceImpl<UserExerciseReviewMapper, UserExerciseReview>
implements IUserExerciseReviewService {
    @Autowired
    UserExerciseReviewMapper userExerciseReviewMapper;
    @Resource
    private RedisTemplate redisTemplate;

    public UserExerciseReview getUserExerciseReview(Long id) {
        return (UserExerciseReview)this.userExerciseReviewMapper.selectById((Serializable)id);
    }

    public Page<UserExerciseReview> getAllUserExerciseReview(Page page) {
        return (Page)this.userExerciseReviewMapper.selectPage((IPage)page, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(Long exerciseId) {
        Long userId = SecurityUtil.getUserId();
        String today = DateUtil.today();
        String key = "LOCK_EXERCISE_REVIEW_" + userId + "_" + today;
        long timeout = 3L;
        if (!this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)Boolean.TRUE, timeout, TimeUnit.SECONDS).booleanValue()) {
            throw new AppException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(UserExerciseReview::getUserId, (Object)userId)).eq(UserExerciseReview::getExerciseId, (Object)exerciseId)).eq(UserExerciseReview::getDate, (Object)today);
        UserExerciseReview db = (UserExerciseReview)this.getOne((Wrapper)qw);
        if (null == db) {
            UserExerciseReview userExerciseReview = new UserExerciseReview();
            userExerciseReview.setUserId(userId);
            userExerciseReview.setExerciseId(exerciseId);
            userExerciseReview.setDate(today);
            userExerciseReview.setTotalCount(Integer.valueOf(1));
            this.userExerciseReviewMapper.insert((Object)userExerciseReview);
        } else {
            Integer totalCount = db.getTotalCount();
            db.setTotalCount(Integer.valueOf(totalCount + 1));
            this.updateById((Object)db);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(UserExerciseReview userExerciseReview) {
        return this.userExerciseReviewMapper.updateById((Object)userExerciseReview);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.userExerciseReviewMapper.deleteBatchIds(Arrays.asList(array));
        }
    }
}

