/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.constant.NoticeEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.MessageLogMapper;
import com.zsy.exam.mapper.UserMessageMapper;
import com.zsy.exam.mapper.UserPostMapper;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.entity.MessageConfig;
import com.zsy.exam.model.entity.MessageLog;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.QuestionFeedback;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.entity.UserMessage;
import com.zsy.exam.model.entity.UserPost;
import com.zsy.exam.model.vo.MessageCountVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IExaminationPaperService;
import com.zsy.exam.service.IMessageConfigService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.service.IUserMessageService;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.service.IWebSocketService;
import com.zsy.exam.util.EmailUtil;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.sms.SmsClientSend;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserMessageServiceImpl
extends ServiceImpl<UserMessageMapper, UserMessage>
implements IUserMessageService {
    @Autowired
    UserMessageMapper userMessageMapper;
    @Autowired
    private IMessageConfigService messageConfigService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private UserPostMapper userPostMapper;
    @Autowired
    private IUserService userService;
    @Autowired
    private IWebSocketService webSocketService;
    @Autowired
    private ICatalogueService catalogueService;
    @Autowired
    private EmailUtil emailUtil;
    @Autowired
    private IQuestionService questionService;
    @Autowired
    private MessageLogMapper messageLogMapper;
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private IExaminationPaperService examinationPaperService;

    public UserMessage getUserMessage(Long id) {
        return (UserMessage)this.userMessageMapper.selectById((Serializable)id);
    }

    public Page<UserMessage> getAllUserMessage(Page page, String type) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Long userId = SecurityUtil.getUserId();
        if (null != type) {
            wrapper.eq(UserMessage::getType, (Object)type);
        }
        ((LambdaQueryWrapper)wrapper.eq(UserMessage::getUserId, (Object)userId)).orderByDesc(UserMessage::getCreateTime);
        return (Page)this.userMessageMapper.selectPage((IPage)page, (Wrapper)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(UserMessage userMessage) {
        this.userMessageMapper.insert((Object)userMessage);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(UserMessage userMessage) {
        return this.userMessageMapper.updateById((Object)userMessage);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !org.springframework.util.CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.userMessageMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public void read(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] array = ids.split(",");
            if (org.springframework.util.CollectionUtils.isEmpty(Arrays.asList(array))) {
                return;
            }
            for (String id : Arrays.asList(array)) {
                UserMessage userMessage = (UserMessage)this.userMessageMapper.selectById((Serializable)Long.valueOf(id));
                userMessage.setIsRead(Integer.valueOf(1));
                this.userMessageMapper.updateById((Object)userMessage);
            }
        }
    }

    public List<MessageCountVO> messageCount() {
        ArrayList<MessageCountVO> list = new ArrayList<MessageCountVO>();
        Long userId = SecurityUtil.getUserId();
        List userMessages = this.userMessageMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserMessage::getIsRead, (Object)0)).eq(UserMessage::getUserId, (Object)userId));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)userMessages)) {
            list.add(new MessageCountVO(NoticeEnum.ANSWER_EXAM.getCode(), Integer.valueOf(0)));
            list.add(new MessageCountVO(NoticeEnum.QUESTION_APPROVE.getCode(), Integer.valueOf(0)));
            list.add(new MessageCountVO(NoticeEnum.QUESTION_FEEDBACK.getCode(), Integer.valueOf(0)));
            list.add(new MessageCountVO(NoticeEnum.EXAMINATION_APPROVE.getCode(), Integer.valueOf(0)));
            list.add(new MessageCountVO(NoticeEnum.MY_FEEDBACK.getCode(), Integer.valueOf(0)));
        }
        Map<String, List<UserMessage>> collect = userMessages.stream().collect(Collectors.groupingBy(UserMessage::getType));
        list.add(new MessageCountVO(NoticeEnum.ANSWER_EXAM.getCode(), Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)collect.get(NoticeEnum.ANSWER_EXAM.getCode())) ? 0 : collect.get(NoticeEnum.ANSWER_EXAM.getCode()).size())));
        list.add(new MessageCountVO(NoticeEnum.QUESTION_APPROVE.getCode(), Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)collect.get(NoticeEnum.QUESTION_APPROVE.getCode())) ? 0 : collect.get(NoticeEnum.QUESTION_APPROVE.getCode()).size())));
        list.add(new MessageCountVO(NoticeEnum.QUESTION_FEEDBACK.getCode(), Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)collect.get(NoticeEnum.QUESTION_FEEDBACK.getCode())) ? 0 : collect.get(NoticeEnum.QUESTION_FEEDBACK.getCode()).size())));
        list.add(new MessageCountVO(NoticeEnum.EXAMINATION_APPROVE.getCode(), Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)collect.get(NoticeEnum.EXAMINATION_APPROVE.getCode())) ? 0 : collect.get(NoticeEnum.EXAMINATION_APPROVE.getCode()).size())));
        list.add(new MessageCountVO(NoticeEnum.MY_FEEDBACK.getCode(), Integer.valueOf(org.springframework.util.CollectionUtils.isEmpty((Collection)collect.get(NoticeEnum.MY_FEEDBACK.getCode())) ? 0 : collect.get(NoticeEnum.MY_FEEDBACK.getCode()).size())));
        return list;
    }

    public void sendMessageQuestion(Question question, Integer type) {
        if (Integer.valueOf(2).equals(type)) {
            this.sendMessageQuestionApprove(question);
            return;
        }
        MessageConfig messageConfig = (MessageConfig)this.messageConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(MessageConfig::getType, (Object)NoticeEnum.QUESTION_APPROVE.getCode()));
        if (null == messageConfig) {
            return;
        }
        Subject subject = this.subjectService.getByCode(question.getCode().substring(0, 3));
        if (null == subject) {
            return;
        }
        List userPosts = this.userPostMapper.getListByPostName("qap", subject.getId());
        if (CollectionUtils.isEmpty((Collection)userPosts)) {
            return;
        }
        SysParam loginUrl = this.sysParamService.getByType(SysParamEnum.LOGIN_URL.getType());
        List<String> sendChannels = Arrays.asList(messageConfig.getSendChannel().split(","));
        for (UserPost userPost : userPosts) {
            User user = (User)this.userService.getById((Serializable)userPost.getUserId());
            String context = "\u5c0a\u656c\u7684\u4e13\u5bb6\uff1a" + user.getRealName() + " \u60a8\u597d\uff01\u76ee\u524d" + subject.getName() + "\u5df2\u6709\u63d0\u4ea4\u7684\u8bd5\u9898\u9700\u8981\u60a8\u5ba1\u6279\uff0c\u8bf7\u60a8\u5728\u65b9\u4fbf\u7684\u65f6\u5019\u5ba1\u9605\u5e76\u7ed9\u51fa\u5b9d\u8d35\u7684\u610f\u89c1\u3002\u60a8\u7684\u4e13\u4e1a\u77e5\u8bc6\u548c\u7ecf\u9a8c\u5bf9\u6211\u4eec\u81f3\u5173\u91cd\u8981\uff0c\u671f\u5f85\u60a8\u7684\u53cd\u9988\u3002\u8c22\u8c22\uff01";
            if (sendChannels.contains("1")) {
                UserMessage userMessage = new UserMessage();
                userMessage.setType(NoticeEnum.QUESTION_APPROVE.getCode());
                userMessage.setContent(context);
                userMessage.setUserId(userPost.getUserId());
                this.save((Object)userMessage);
                this.addMessageLog(userPost.getUserId(), NoticeEnum.QUESTION_APPROVE.getCode(), "1");
                this.webSocketService.sendMessageForMap(NoticeEnum.QUESTION_APPROVE.getCode(), Arrays.asList(userPost.getUserId()));
            }
            if (sendChannels.contains("2")) {
                if (Integer.valueOf(1).equals(type) && null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                    context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
                }
                SmsClientSend.sendSms((String)user.getMobile(), (String)context);
                this.addMessageLog(userPost.getUserId(), NoticeEnum.QUESTION_APPROVE.getCode(), "2");
            }
            if (!sendChannels.contains("3")) continue;
            if (Integer.valueOf(1).equals(type) && null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
            }
            this.emailUtil.sendEmail(user.getEmail(), "\u8bd5\u9898\u5ba1\u6279", context);
            this.addMessageLog(userPost.getUserId(), NoticeEnum.QUESTION_APPROVE.getCode(), "3");
        }
    }

    public void sendMessageQuestionApprove(Question question) {
        MessageConfig messageConfig = (MessageConfig)this.messageConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(MessageConfig::getType, (Object)NoticeEnum.QUESTION_APPROVE.getCode()));
        if (null == messageConfig) {
            return;
        }
        Subject subject = this.subjectService.getByCode(question.getCode().substring(0, 3));
        if (null == subject) {
            return;
        }
        List<String> sendChannels = Arrays.asList(messageConfig.getSendChannel().split(","));
        User user = (User)this.userService.getById((Serializable)question.getUserId());
        Catalogue catalogue = (Catalogue)this.catalogueService.getById((Serializable)question.getRepoId());
        String context = "\u5c0a\u656c\u7684" + user.getRealName() + " \u60a8\u597d\uff01\u5173\u4e8e\u60a8\u65e9\u524d\u63d0\u4ea4\u7684\u7533\u8bf7\uff0c\u65e8\u5728\u5c06\u60a8\u4e2a\u4eba\u9898\u5e93\u4e2d" + subject.getName() + "\u5b66\u79d1\u4e0b\uff0c\u6db5\u76d6" + (String)(catalogue.getName().length() <= 15 ? catalogue.getName() : catalogue.getName().substring(0, 15) + "....") + "\u7684" + (String)(question.getContent().length() <= 10 ? question.getContent() : question.getContent().substring(0, 10) + "....") + "\u7cbe\u5f69\u8bd5\u9898\u7eb3\u5165\u6821\u56ed\u9898\u5e93\uff0c\u6211\u4eec\u5df2\u8fdb\u884c\u4e86\u7ec6\u81f4\u7684\u5ba1\u9605\u4e0e\u8bc4\u4f30\u3002\u76ee\u524d\uff0c\u60a8\u7684\u7533\u8bf7\u5df2\u5ba1\u6838\uff0c\u5177\u4f53\u72b6\u6001\u4e3a\uff1a" + (Integer.valueOf(1).equals(question.getApproveStatus()) ? "\u901a\u8fc7" : "\u9a73\u56de") + "\uff0c \u610f\u89c1\uff1a" + (StringUtils.isBlank((CharSequence)question.getRejectReason()) ? "\u65e0" : question.getRejectReason()) + "\u3002";
        if (sendChannels.contains("1")) {
            UserMessage userMessage = new UserMessage();
            userMessage.setType(NoticeEnum.QUESTION_APPROVE.getCode());
            userMessage.setContent(context);
            userMessage.setUserId(user.getId());
            this.save((Object)userMessage);
            this.webSocketService.sendMessageForMap(NoticeEnum.QUESTION_APPROVE.getCode(), Arrays.asList(user.getId()));
            this.addMessageLog(user.getId(), NoticeEnum.QUESTION_APPROVE.getCode(), "1");
        }
        if (sendChannels.contains("2")) {
            SmsClientSend.sendSms((String)user.getMobile(), (String)context);
            this.addMessageLog(user.getId(), NoticeEnum.QUESTION_APPROVE.getCode(), "2");
        }
        if (sendChannels.contains("3")) {
            this.emailUtil.sendEmail(user.getEmail(), "\u8bd5\u9898\u5ba1\u6279", context);
            this.addMessageLog(user.getId(), NoticeEnum.QUESTION_APPROVE.getCode(), "3");
        }
    }

    public void sendMessageFeedback(QuestionFeedback db, Integer type) {
        if (Integer.valueOf(2).equals(type)) {
            this.sendMessageFeedbackApprove(db);
            return;
        }
        MessageConfig messageConfig = (MessageConfig)this.messageConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(MessageConfig::getType, (Object)NoticeEnum.QUESTION_FEEDBACK.getCode()));
        if (null == messageConfig) {
            return;
        }
        Question question = (Question)this.questionService.getById((Serializable)db.getQuestionId());
        Subject subject = this.subjectService.getByCode(question.getCode().substring(0, 3));
        if (null == subject) {
            return;
        }
        List userPosts = this.userPostMapper.getListByPostName("qap", subject.getId());
        if (CollectionUtils.isEmpty((Collection)userPosts)) {
            return;
        }
        List<String> sendChannels = Arrays.asList(messageConfig.getSendChannel().split(","));
        SysParam loginUrl = this.sysParamService.getByType(SysParamEnum.LOGIN_URL.getType());
        for (UserPost userPost : userPosts) {
            User user = (User)this.userService.getById((Serializable)userPost.getUserId());
            String context = user.getRealName() + " \u60a8\u597d\uff01\u76ee\u524d" + subject.getName() + "\u5df2\u6709\u63d0\u4ea4\u7684\u8bd5\u9898\u53cd\u9988\u9700\u8981\u60a8\u6821\u5bf9\uff0c\u8bf7\u60a8\u5728\u65b9\u4fbf\u7684\u65f6\u5019\u8ba4\u771f\u5ba1\u9605\u3002\u60a8\u7684\u4e13\u4e1a\u77e5\u8bc6\u548c\u7ecf\u9a8c\u5c06\u5bf9\u6211\u4eec\u7684\u8bd5\u9898\u8d28\u91cf\u63d0\u5347\u6709\u5f88\u5927\u5e2e\u52a9\uff0c\u671f\u5f85\u60a8\u7684\u5b9d\u8d35\u610f\u89c1\u3002\u8c22\u8c22\uff01";
            if (sendChannels.contains("1")) {
                UserMessage userMessage = new UserMessage();
                userMessage.setType(NoticeEnum.QUESTION_FEEDBACK.getCode());
                userMessage.setContent(context);
                userMessage.setUserId(userPost.getUserId());
                this.save((Object)userMessage);
                this.webSocketService.sendMessageForMap(NoticeEnum.QUESTION_FEEDBACK.getCode(), Arrays.asList(userPost.getUserId()));
                this.addMessageLog(userPost.getUserId(), NoticeEnum.QUESTION_FEEDBACK.getCode(), "1");
            }
            if (sendChannels.contains("2")) {
                if (Integer.valueOf(1).equals(type) && null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                    context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
                }
                SmsClientSend.sendSms((String)user.getMobile(), (String)context);
                this.addMessageLog(userPost.getUserId(), NoticeEnum.QUESTION_FEEDBACK.getCode(), "2");
            }
            if (!sendChannels.contains("3")) continue;
            if (Integer.valueOf(1).equals(type) && null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
            }
            this.emailUtil.sendEmail(user.getEmail(), "\u8bd5\u9898\u53cd\u9988", context);
            this.addMessageLog(userPost.getUserId(), NoticeEnum.QUESTION_FEEDBACK.getCode(), "3");
        }
    }

    public void sendMessageFeedbackApprove(QuestionFeedback db) {
        MessageConfig messageConfig = (MessageConfig)this.messageConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(MessageConfig::getType, (Object)NoticeEnum.QUESTION_FEEDBACK.getCode()));
        if (null == messageConfig) {
            return;
        }
        Question question = (Question)this.questionService.getById((Serializable)db.getQuestionId());
        Subject subject = this.subjectService.getByCode(question.getCode().substring(0, 3));
        if (null == subject) {
            return;
        }
        List<String> sendChannels = Arrays.asList(messageConfig.getSendChannel().split(","));
        User user = (User)this.userService.getById((Serializable)db.getCreatorId());
        Catalogue catalogue = (Catalogue)this.catalogueService.getById((Serializable)question.getRepoId());
        String context = user.getRealName() + " \u60a8\u597d\uff01\u60a8\u4e4b\u524d\u63d0\u4ea4\u7684\u5173\u4e8e" + (String)(catalogue.getName().length() <= 15 ? catalogue.getName() : catalogue.getName().substring(0, 15) + "....") + " " + (String)(question.getContent().length() <= 10 ? question.getContent() : question.getContent().substring(0, 10) + "....") + "\u7684\u53cd\u9988\uff0c\u5df2\u7ecf\u76f8\u5173\u4e13\u5bb6\u5904\u7406\u5b8c\u6bd5\u3002\u4ee5\u4e0b\u662f\u5904\u7406\u610f\u89c1\uff1a\u72b6\u6001\uff1a" + (Integer.valueOf(2).equals(db.getDealStatus()) ? "\u901a\u8fc7" : "\u62d2\u7edd") + "\uff0c \u610f\u89c1\uff1a" + (StringUtils.isBlank((CharSequence)db.getDealInfo()) ? "\u65e0" : db.getDealInfo()) + "\u3002\u611f\u8c22\u60a8\u5bf9\u6559\u5b66\u5de5\u4f5c\u7684\u5173\u5fc3\u4e0e\u652f\u6301\uff0c\u60a8\u7684\u53cd\u9988\u5bf9\u6211\u4eec\u5341\u5206\u91cd\u8981\u3002\u5982\u679c\u60a8\u5bf9\u5904\u7406\u610f\u89c1\u6709\u4efb\u4f55\u7591\u95ee\u6216\u9700\u8981\u8fdb\u4e00\u6b65\u6c9f\u901a\uff0c\u8bf7\u968f\u65f6\u4e0e\u6211\u4eec\u8054\u7cfb\u3002";
        if (sendChannels.contains("1")) {
            UserMessage userMessage = new UserMessage();
            userMessage.setType(NoticeEnum.QUESTION_FEEDBACK.getCode());
            userMessage.setContent(context);
            userMessage.setUserId(user.getId());
            this.save((Object)userMessage);
            this.webSocketService.sendMessageForMap(NoticeEnum.QUESTION_FEEDBACK.getCode(), Arrays.asList(user.getId()));
            this.addMessageLog(user.getId(), NoticeEnum.QUESTION_FEEDBACK.getCode(), "1");
        }
        if (sendChannels.contains("2")) {
            SmsClientSend.sendSms((String)user.getMobile(), (String)context);
            this.addMessageLog(user.getId(), NoticeEnum.QUESTION_FEEDBACK.getCode(), "2");
        }
        if (sendChannels.contains("3")) {
            this.emailUtil.sendEmail(user.getEmail(), "\u8bd5\u9898\u53cd\u9988", context);
            this.addMessageLog(user.getId(), NoticeEnum.QUESTION_FEEDBACK.getCode(), "3");
        }
    }

    public void sendMessageExaminationPaper(ExaminationPaper db, Integer type) {
        if (Integer.valueOf(2).equals(type)) {
            this.sendMessageExaminationPaperApprove(db);
            return;
        }
        MessageConfig messageConfig = (MessageConfig)this.messageConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(MessageConfig::getType, (Object)NoticeEnum.EXAMINATION_APPROVE.getCode()));
        if (null == messageConfig) {
            return;
        }
        Subject subject = this.subjectService.getByCode(db.getSubjectCode());
        if (null == subject) {
            return;
        }
        SysParam isPaperApprove = this.sysParamService.getByType(SysParamEnum.PAPER_APPROVE.getType());
        if (null != isPaperApprove && !"1".equals(isPaperApprove.getValue())) {
            return;
        }
        List userPosts = this.userPostMapper.getListByPostName("pap", subject.getId());
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)userPosts)) {
            return;
        }
        List<String> sendChannels = Arrays.asList(messageConfig.getSendChannel().split(","));
        SysParam loginUrl = this.sysParamService.getByType(SysParamEnum.LOGIN_URL.getType());
        for (UserPost userPost : userPosts) {
            User user = (User)this.userService.getById((Serializable)userPost.getUserId());
            String context = "\u5c0a\u656c\u7684\u4e13\u5bb6\uff1a" + user.getRealName() + " \u60a8\u597d\uff01\u76ee\u524d" + subject.getName() + "\u5df2\u6709\u63d0\u4ea4\u7684 " + db.getName() + " \u9700\u8981\u60a8\u5ba1\u6279\u3002\u8bf7\u60a8\u5728\u65b9\u4fbf\u7684\u65f6\u5019\u5ba1\u9605\u8fd9\u4efd\u8bd5\u5377\uff0c\u5e76\u7ed9\u51fa\u60a8\u7684\u5b9d\u8d35\u610f\u89c1\u3002\u60a8\u7684\u4e13\u4e1a\u77e5\u8bc6\u548c\u7ecf\u9a8c\u5bf9\u6211\u4eec\u975e\u5e38\u91cd\u8981\uff0c\u671f\u5f85\u60a8\u7684\u53cd\u9988\u3002\u8c22\u8c22\uff01";
            if (sendChannels.contains("1")) {
                UserMessage userMessage = new UserMessage();
                userMessage.setType(NoticeEnum.EXAMINATION_APPROVE.getCode());
                userMessage.setContent(context);
                userMessage.setUserId(userPost.getUserId());
                this.save((Object)userMessage);
                this.webSocketService.sendMessageForMap(NoticeEnum.EXAMINATION_APPROVE.getCode(), Arrays.asList(userPost.getUserId()));
                this.addMessageLog(userPost.getUserId(), NoticeEnum.EXAMINATION_APPROVE.getCode(), "1");
            }
            if (sendChannels.contains("2")) {
                if (Integer.valueOf(1).equals(type) && null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                    context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
                }
                SmsClientSend.sendSms((String)user.getMobile(), (String)context);
                this.addMessageLog(userPost.getUserId(), NoticeEnum.EXAMINATION_APPROVE.getCode(), "2");
            }
            if (!sendChannels.contains("3")) continue;
            if (Integer.valueOf(1).equals(type) && null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
            }
            this.emailUtil.sendEmail(user.getEmail(), "\u8bd5\u5377\u5ba1\u6279", context);
            this.addMessageLog(userPost.getUserId(), NoticeEnum.EXAMINATION_APPROVE.getCode(), "3");
        }
    }

    private void sendMessageExaminationPaperApprove(ExaminationPaper db) {
        MessageConfig messageConfig = (MessageConfig)this.messageConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(MessageConfig::getType, (Object)NoticeEnum.EXAMINATION_APPROVE.getCode()));
        if (null == messageConfig) {
            return;
        }
        Subject subject = this.subjectService.getByCode(db.getSubjectCode());
        if (null == subject) {
            return;
        }
        List<String> sendChannels = Arrays.asList(messageConfig.getSendChannel().split(","));
        User user = (User)this.userService.getById((Serializable)db.getCreatorId());
        String context = "\u5c0a\u656c\u7684" + user.getRealName() + " \u60a8\u597d\uff01\u5173\u4e8e\u60a8\u6b64\u524d\u63d0\u4ea4\u7684" + subject.getName() + "\u5b66\u79d1\uff0c\u9488\u5bf9 " + db.getName() + " \u5e94\u7528\u4e8e\u8003\u8bd5\u7684\u7533\u8bf7\uff0c\u76f8\u5173\u4e13\u5bb6\u8fdb\u884c\u4e86\u7ec6\u81f4\u7684\u5ba1\u6838\uff0c\u5ba1\u6838\u72b6\u6001\uff1a" + (Integer.valueOf(1).equals(db.getApproveStatus()) ? "\u901a\u8fc7" : "\u62d2\u7edd") + "\uff0c \u610f\u89c1\uff1a" + (StringUtils.isBlank((CharSequence)db.getRejectReason()) ? "\u65e0" : db.getRejectReason()) + "\u3002\u611f\u8c22\u60a8\u5bf9\u6559\u5b66\u5de5\u4f5c\u7684\u5173\u5fc3\u4e0e\u652f\u6301\uff0c\u60a8\u7684\u53cd\u9988\u5bf9\u6211\u4eec\u5341\u5206\u91cd\u8981\u3002\u5982\u679c\u60a8\u5bf9\u5904\u7406\u610f\u89c1\u6709\u4efb\u4f55\u7591\u95ee\u6216\u9700\u8981\u8fdb\u4e00\u6b65\u6c9f\u901a\uff0c\u8bf7\u968f\u65f6\u4e0e\u6211\u4eec\u8054\u7cfb\u3002";
        if (sendChannels.contains("1")) {
            UserMessage userMessage = new UserMessage();
            userMessage.setType(NoticeEnum.EXAMINATION_APPROVE.getCode());
            userMessage.setContent(context);
            userMessage.setUserId(user.getId());
            this.save((Object)userMessage);
            this.webSocketService.sendMessageForMap(NoticeEnum.EXAMINATION_APPROVE.getCode(), Arrays.asList(user.getId()));
            this.addMessageLog(user.getId(), NoticeEnum.EXAMINATION_APPROVE.getCode(), "1");
        }
        if (sendChannels.contains("2")) {
            SmsClientSend.sendSms((String)user.getMobile(), (String)context);
            this.addMessageLog(user.getId(), NoticeEnum.EXAMINATION_APPROVE.getCode(), "2");
        }
        if (sendChannels.contains("3")) {
            this.emailUtil.sendEmail(user.getEmail(), "\u8bd5\u5377\u5ba1\u6279", context);
            this.addMessageLog(user.getId(), NoticeEnum.EXAMINATION_APPROVE.getCode(), "3");
        }
    }

    public void sendMessageExam(Exam exam, List<Long> userIds) {
        if (StringUtils.isBlank((CharSequence)exam.getSendChannel())) {
            return;
        }
        ExaminationPaper db = (ExaminationPaper)this.examinationPaperService.getById((Serializable)exam.getExaminationPaperId());
        Subject subject = this.subjectService.getByCode(db.getSubjectCode());
        if (null == subject) {
            return;
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        List<String> sendChannels = Arrays.asList(exam.getSendChannel().split(","));
        SysParam loginUrl = this.sysParamService.getByType(SysParamEnum.LOGIN_URL.getType());
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        for (Long userId : userIds) {
            User user = (User)this.userService.getById((Serializable)userId);
            String date = exam.getEndTime().format(format);
            Long id = ((UserMessageMapper)this.baseMapper).isExists(userId, NoticeEnum.ANSWER_EXAM.getCode(), date);
            if (null != id) continue;
            String context = "\u5c0a\u656c\u7684" + user.getRealName() + "\uff1a\u60a8\u597d\uff01\u73b0\u901a\u77e5\u60a8\u53c2\u4e0e" + subject.getName() + " " + exam.getTitle() + "\u7684\u9605\u5377\u5de5\u4f5c\u3002\u672c\u6b21\u8003\u8bd5\u5df2\u4e8e" + exam.getEndTime().format(dateTimeFormatter) + "\u5b8c\u6210\uff0c\u76ee\u524d\u8fdb\u5165\u9605\u5377\u9636\u6bb5\u3002\u8bf7\u60a8\u5728" + exam.getEndTime().format(dateTimeFormatter) + "\u81f3" + exam.getMarkingEndTime().format(dateTimeFormatter) + "\u671f\u95f4\u5b8c\u6210\u9605\u5377\u4efb\u52a1\u3002";
            if (sendChannels.contains("1")) {
                UserMessage userMessage = new UserMessage();
                userMessage.setType(NoticeEnum.ANSWER_EXAM.getCode());
                userMessage.setContent(context);
                userMessage.setUserId(userId);
                this.save((Object)userMessage);
                this.webSocketService.sendMessageForMap(NoticeEnum.ANSWER_EXAM.getCode(), userIds);
                this.addMessageLog(userId, NoticeEnum.ANSWER_EXAM.getCode(), "1");
            }
            if (sendChannels.contains("2")) {
                if (null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                    context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
                }
                SmsClientSend.sendSms((String)user.getMobile(), (String)context);
                this.addMessageLog(userId, NoticeEnum.ANSWER_EXAM.getCode(), "2");
            }
            if (!sendChannels.contains("3")) continue;
            if (null != loginUrl && StringUtils.isNotBlank((CharSequence)loginUrl.getValue())) {
                context = context + "\u767b\u5f55\u5730\u5740\uff1a" + loginUrl.getValue();
            }
            this.emailUtil.sendEmail(user.getEmail(), "\u9605\u5377\u901a\u77e5", context);
            this.addMessageLog(userId, NoticeEnum.ANSWER_EXAM.getCode(), "3");
        }
    }

    private void addMessageLog(Long userId, String type, String sendChannel) {
        MessageLog messageLog = new MessageLog();
        messageLog.setUserId(userId);
        messageLog.setType(type);
        messageLog.setSendChannel(sendChannel);
        this.messageLogMapper.insert((Object)messageLog);
    }
}

