/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.controller.ExaminationPaperController;
import com.zsy.exam.converter.UserConverter;
import com.zsy.exam.mapper.ClbumHeadTeacherMapper;
import com.zsy.exam.mapper.ClbumMapper;
import com.zsy.exam.mapper.UserMapper;
import com.zsy.exam.mapper.UserPostMapper;
import com.zsy.exam.mapper.UserRoleMapper;
import com.zsy.exam.model.dto.UserOperateLogDTO;
import com.zsy.exam.model.dto.UserPostDTO;
import com.zsy.exam.model.dto.UserUpdateDTO;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.entity.UserPost;
import com.zsy.exam.model.entity.UserRole;
import com.zsy.exam.model.form.UserForm;
import com.zsy.exam.model.vo.MenuTreeListVO;
import com.zsy.exam.model.vo.UserVO;
import com.zsy.exam.model.vo.region.SchoolInfoExportVo;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.IStaffService;
import com.zsy.exam.service.IStudentService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.util.AESEncryptUtils;
import com.zsy.exam.util.CryptoUtils;
import com.zsy.exam.util.DateTimeUtil;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.ZhglUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserServiceImpl
extends ServiceImpl<UserMapper, User>
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Resource
    private UserMapper userMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private HttpServletRequest request;
    @Resource
    private UserConverter userConverter;
    @Resource
    private ClbumMapper clbumMapper;
    @Resource
    private IQuestionService iQuestionService;
    @Resource
    private IRoleService roleService;
    @Resource
    private UserPostMapper userPostMapper;
    @Resource
    private IStudentService studentService;
    @Resource
    private ISysParamService sysParamService;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    @Lazy
    private ISubjectService subjectService;
    @Resource
    private IStaffService staffService;
    @Resource
    private ZhglUtil zhglUtil;
    @Resource
    private ClbumHeadTeacherMapper clbumHeadTeacherMapper;

    public Result<String> createUser(UserForm userForm) {
        userForm.setPassword(new BCryptPasswordEncoder().encode((CharSequence)"123456"));
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            userForm.setRoleId(Integer.valueOf(1));
        }
        if (userForm.getRoleId() == null || userForm.getRoleId() == 0) {
            return Result.failed((String)"\u8bf7\u9009\u62e9\u7528\u6237\u89d2\u8272");
        }
        User user = this.userConverter.fromToEntity(userForm);
        this.userMapper.insert((Object)user);
        return Result.success((String)"\u7528\u6237\u521b\u5efa\u6210\u529f");
    }

    public Result<String> updatePassword(UserForm userForm) {
        if (!userForm.getNewPassword().equals(userForm.getCheckedPassword())) {
            return Result.failed((String)"\u4e24\u6b21\u5bc6\u7801\u4e0d\u4e00\u81f4");
        }
        Long userId = SecurityUtil.getUserId();
        User user = (User)this.userMapper.selectById((Serializable)userId);
        if (!new BCryptPasswordEncoder().matches((CharSequence)userForm.getOriginPassword(), user.getPassword())) {
            return Result.failed((String)"\u65e7\u5bc6\u7801\u9519\u8bef");
        }
        SysParam passwordSize = this.sysParamService.getByType(SysParamEnum.PASSWORD_MIN_SIZE.getType());
        SysParam passwordInclude = this.sysParamService.getByType(SysParamEnum.PASSWORD_INCLUDE.getType());
        if (null != passwordSize && StringUtils.isNotBlank((CharSequence)passwordSize.getValue()) && Integer.valueOf(passwordSize.getValue()) > userForm.getNewPassword().length()) {
            return Result.failed((String)("\u5bc6\u7801\u5fc5\u987b\u8981" + passwordSize.getValue() + "\u4f4d\u6570"));
        }
        if (null != passwordInclude && StringUtils.isNotBlank((CharSequence)passwordInclude.getValue())) {
            List<String> includes = Arrays.asList(passwordInclude.getValue().split(","));
            Pattern pattern = Pattern.compile("[0-9]");
            Pattern pattern2 = Pattern.compile("[a-z]");
            Pattern pattern3 = Pattern.compile("[A-Z]");
            Pattern pattern4 = Pattern.compile("[ _`!@#$%^&*()+=|{}\u2019:;\u2019,.<>/?\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]|\\n|\\r|\\t");
            block6: for (String c : includes) {
                switch (Integer.valueOf(c)) {
                    case 1: {
                        Matcher m1 = pattern.matcher(userForm.getNewPassword());
                        boolean matches1 = m1.find();
                        if (matches1) continue block6;
                        return Result.failed((String)"\u5bc6\u7801\u5fc5\u987b\u542b\u6709\u6570\u5b57");
                    }
                    case 2: {
                        Matcher m2 = pattern2.matcher(userForm.getNewPassword());
                        boolean matches2 = m2.find();
                        if (matches2) continue block6;
                        return Result.failed((String)"\u5bc6\u7801\u5fc5\u987b\u542b\u6709\u5c0f\u5199\u5b57\u6bcd");
                    }
                    case 3: {
                        Matcher m3 = pattern3.matcher(userForm.getNewPassword());
                        boolean matches3 = m3.find();
                        if (matches3) continue block6;
                        return Result.failed((String)"\u5bc6\u7801\u5fc5\u987b\u542b\u6709\u5927\u5199\u5b57\u6bcd");
                    }
                    case 4: {
                        Matcher m4 = pattern4.matcher(userForm.getNewPassword());
                        boolean matches4 = m4.find();
                        if (matches4) continue block6;
                        return Result.failed((String)"\u5bc6\u7801\u5fc5\u987b\u542b\u6709\u7279\u6b8a\u5b57\u7b26");
                    }
                }
                return Result.failed((String)"\u5bc6\u7801\u8bbe\u7f6e\u4e0d\u6b63\u786e,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)userForm.getNewPassword()));
        user.setLastChangePasswordTime(LocalDateTime.now());
        this.userMapper.updateById((Object)user);
        this.stringRedisTemplate.delete((Object)(this.request.getSession().getId() + "token"));
        return Result.success((String)"\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    public void resetPassword(Long userId) {
        User user = (User)this.userMapper.selectById((Serializable)userId);
        if (null == user) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        user.setPassword(this.getPasswordDefault(AESEncryptUtils.decrypt((String)user.getIdNo())));
        user.setLastChangePasswordTime(LocalDateTime.now());
        this.updateById((Object)user);
    }

    public void updateUser(UserUpdateDTO dto) {
        User user = (User)this.getById((Serializable)dto.getId());
        if (null == user) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getIsDeleted, (Object)false)).ne(User::getId, (Object)dto.getId())).eq(User::getMobile, (Object)dto.getMobile());
        List users = this.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            throw new AppException("\u5f53\u524d\u624b\u673a\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u4fee\u6539");
        }
        user.setAvatar(dto.getAvatar());
        user.setMobile(dto.getMobile());
        user.setEmail(dto.getEmail());
        user.setRealName(dto.getUserRealName());
        this.updateById((Object)user);
    }

    @Transactional
    public Result<String> deleteBatchByIds(String ids) {
        List<Long> userIds = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
        Integer row = this.userMapper.deleteByUserIds(userIds);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Transactional
    public Result<String> importUsers(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            return Result.failed((String)"\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        List list = ExcelUtils.readMultipartFile((MultipartFile)file, UserForm.class);
        list.forEach(userForm -> {
            userForm.setPassword(new BCryptPasswordEncoder().encode((CharSequence)"123456"));
            userForm.setCreateTime(DateTimeUtil.getDateTime());
            if (userForm.getRoleId() == null) {
                userForm.setRoleId(Integer.valueOf(1));
            }
        });
        if (list.size() > 300) {
            return Result.failed((String)"\u8868\u4e2d\u6700\u591a\u5b58\u653e300\u6761\u6570\u636e");
        }
        this.userMapper.insertBatchUser(this.userConverter.listFromToEntity(list));
        return Result.success((String)"\u7528\u6237\u5bfc\u5165\u6210\u529f");
    }

    public Result<UserVO> info() {
        UserVO userVo = null;
        ArrayList subjectList = new ArrayList();
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.STUDENT.getCode())) {
            userVo = this.userMapper.infoByStudent(SecurityUtil.getUserId());
        } else if (roles.contains(RoleEnum.TEACHER.getCode())) {
            userVo = this.userMapper.infoByStaff(SecurityUtil.getUserId());
            userVo.setPostCodeList(SecurityUtil.getPostCodeList());
            List subjectCode = SecurityUtil.getSubjectCode();
            subjectCode.forEach(subCode -> {
                Subject subject = this.subjectService.getByCode(subCode);
                subjectList.add(subject);
            });
            userVo.setSubjectList(subjectList);
            List headTeacherClbum = this.clbumHeadTeacherMapper.getHeadTeacherClbum(userVo.getStaffId());
            userVo.setClbumSimpleVOS(headTeacherClbum);
        } else {
            userVo = this.userMapper.info(SecurityUtil.getUserId());
            userVo.setPostCodeList(SecurityUtil.getPostCodeList());
            LambdaQueryWrapper sbqw = new LambdaQueryWrapper();
            sbqw.eq(Subject::getEnable, (Object)Boolean.TRUE);
            userVo.setSubjectList(this.subjectService.list((Wrapper)sbqw));
        }
        userVo.setMobile(AESEncryptUtils.decrypt((String)userVo.getMobile()));
        userVo.setPassword(null);
        return Result.success(null, (Object)userVo);
    }

    public List<MenuTreeListVO> getRoleMenuList() {
        List roles = this.roleService.getCurrentRoles();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)roles)) {
            return new ArrayList<MenuTreeListVO>();
        }
        List roleMenuList = this.roleService.getRoleMenuList(roles);
        return roleMenuList;
    }

    public Result<String> joinClbum(String code) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Clbum::getCode, (Object)code);
        Clbum clbum = (Clbum)this.clbumMapper.selectOne((Wrapper)wrapper);
        if (Objects.isNull(clbum)) {
            return Result.failed((String)"\u73ed\u7ea7\u53e3\u4ee4\u4e0d\u5b58\u5728");
        }
        User user = new User();
        user.setId(SecurityUtil.getUserId());
        user.setClbumId(clbum.getId());
        int updated = this.userMapper.updateById((Object)user);
        if (updated > 0) {
            return Result.success((String)("\u52a0\u5165\u73ed\u7ea7\uff1a" + clbum.getClbumName() + "\u6210\u529f"));
        }
        return Result.failed((String)"\u52a0\u5165\u5931\u8d25");
    }

    public Result<IPage<UserVO>> pagingUser(Integer pageNum, Integer pageSize, Long clbumId, String realName) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        List roles = this.roleService.getCurrentRoles();
        page = roles.contains(RoleEnum.TEACHER.getCode()) ? this.userMapper.pagingUser((IPage)page, clbumId, realName, SecurityUtil.getUserId(), Long.valueOf(1L)) : this.userMapper.pagingUser((IPage)page, clbumId, realName, SecurityUtil.getUserId(), null);
        return Result.success(null, (Object)page);
    }

    @Transactional
    public Result<String> uploadAvatar(MultipartFile file) {
        Result result = this.iQuestionService.uploadImage(file);
        System.out.println(result);
        if (result.getCode() == 0) {
            return Result.failed((String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
        }
        String url = (String)result.getData();
        System.out.println(url);
        User user = new User();
        user.setId(SecurityUtil.getUserId());
        user.setAvatar(url);
        if (this.userMapper.updateById((Object)user) > 0) {
            return Result.success((String)"\u4e0a\u4f20\u6210\u529f", (Object)url);
        }
        return Result.failed((String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
    }

    public void unbind(Long userId, String cloumn) {
        this.userMapper.unbind(userId, cloumn);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addUserPosts(List<UserPostDTO> dtos) {
        if (org.springframework.util.CollectionUtils.isEmpty(dtos)) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        for (UserPostDTO dto : dtos) {
            this.userPostMapper.delete((Wrapper)new LambdaQueryWrapper().eq(UserPost::getUserId, (Object)dto.getUserId()));
            for (Long postId : dto.getPostIds()) {
                UserPost userPost = new UserPost();
                userPost.setUserId(dto.getUserId());
                userPost.setPostId(postId);
                this.userPostMapper.insert((Object)userPost);
            }
        }
    }

    public List<Long> getUserPosts(Long userId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(UserPost::getUserId, (Object)userId);
        List userPosts = this.userPostMapper.selectList((Wrapper)qw);
        if (CollUtil.isNotEmpty((Collection)userPosts)) {
            return userPosts.stream().map(UserPost::getPostId).toList();
        }
        return new ArrayList<Long>();
    }

    public void syncZhglUser(UserOperateLogDTO dto) {
        List staffList = this.zhglUtil.getStaffList(dto);
        this.staffService.syncStaff(staffList);
        List studentList = this.zhglUtil.getStudentList(dto);
        this.studentService.syncStudent(studentList);
    }

    public SchoolInfoExportVo exportSchoolInfo() {
        SchoolInfoExportVo schoolInfoExportVo = new SchoolInfoExportVo();
        schoolInfoExportVo.setSyncSource(Integer.valueOf(1));
        LambdaQueryWrapper userQw = new LambdaQueryWrapper();
        userQw.notIn(User::getId, new Object[]{1L, 2L});
        List users = this.list((Wrapper)userQw);
        schoolInfoExportVo.setUserList(users);
        List studentList = this.studentService.list();
        schoolInfoExportVo.setStudentList(studentList);
        List staffList = this.staffService.list();
        schoolInfoExportVo.setStaffList(staffList);
        List clbums = this.clbumMapper.selectList((Wrapper)new LambdaQueryWrapper());
        schoolInfoExportVo.setClbumList(clbums);
        LambdaQueryWrapper userRoleQw = new LambdaQueryWrapper();
        userRoleQw.notIn(UserRole::getUserId, new Object[]{1L, 2L});
        List userRoles = this.userRoleMapper.selectList((Wrapper)userRoleQw);
        schoolInfoExportVo.setUserRoleList(userRoles);
        List clbumHeadTeachers = this.clbumHeadTeacherMapper.selectList((Wrapper)new LambdaQueryWrapper());
        schoolInfoExportVo.setClbumHeadTeachersList(clbumHeadTeachers);
        return schoolInfoExportVo;
    }

    @Transactional
    public void importSchoolInfo(SchoolInfoExportVo vo) {
        Integer syncSource = vo.getSyncSource();
        this.physicalDeleteBySyncSource(syncSource);
        List clbumList = vo.getClbumList();
        clbumList.parallelStream().forEach(a -> {
            a.setSyncSource(syncSource);
            this.clbumMapper.insert(a);
        });
        List userList = vo.getUserList();
        userList.parallelStream().forEach(a -> a.setSyncSource(syncSource));
        this.saveBatch((Collection)userList);
        List staffList = vo.getStaffList();
        staffList.parallelStream().forEach(a -> a.setSyncSource(syncSource));
        this.staffService.saveBatch((Collection)staffList);
        List studentList = vo.getStudentList();
        studentList.parallelStream().forEach(a -> a.setSyncSource(syncSource));
        this.studentService.saveBatch((Collection)studentList);
        List userRoleList = vo.getUserRoleList();
        userRoleList.parallelStream().forEach(a -> {
            a.setSyncSource(syncSource);
            this.userRoleMapper.insert(a);
        });
        List clbumHeadTeachersList = vo.getClbumHeadTeachersList();
        clbumHeadTeachersList.parallelStream().forEach(a -> {
            a.setSyncSource(syncSource);
            this.clbumHeadTeacherMapper.insert(a);
        });
    }

    public void importSchoolInfoOnline() {
        SysParam serviceIpSys = this.sysParamService.getByType(SysParamEnum.YZS_SERVE_IP.getType());
        if (null == serviceIpSys) {
            throw new AppException("\u8bf7\u914d\u7f6e\u6613\u76f4\u5347\u7684ip/\u57df\u540d");
        }
        String ip = serviceIpSys.getValue();
        String url = ip + "/api/user/sync/schoolInfo/export";
        String reJson = HttpUtil.get((String)url);
        Result result = (Result)JSONUtil.toBean((String)reJson, Result.class);
        String data = String.valueOf(result.getData());
        String json = null;
        try {
            json = CryptoUtils.decryptSymmetrically((String)ExaminationPaperController.exportSecretKey, null, (String)data, (CryptoUtils.Algorithm)CryptoUtils.Algorithm.Encryption.AES_ECB_PKCS5);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new AppException("\u6570\u636e\u5bfc\u5165\u5931\u8d25");
        }
        SchoolInfoExportVo exportVo = (SchoolInfoExportVo)JSONUtil.toBean((String)json, SchoolInfoExportVo.class);
        this.importSchoolInfo(exportVo);
    }

    @Transactional
    public void physicalDeleteBySyncSource(Integer syncSource) {
        ((UserMapper)this.baseMapper).physicalDeleteBySyncSource(syncSource);
        this.studentService.physicalDeleteBySyncSource(syncSource);
        this.staffService.physicalDeleteBySyncSource(syncSource);
        this.clbumMapper.physicalDeleteBySyncSource(syncSource);
        this.userRoleMapper.physicalDeleteBySyncSource(syncSource);
        this.clbumHeadTeacherMapper.physicalDeleteBySyncSource(syncSource);
    }

    private String getPasswordDefault(String idNo) {
        SysParam passwordGenerateType = this.sysParamService.getByType(SysParamEnum.PASSWORD_GENERATE_TYPE.getType());
        SysParam passwordTeacher = this.sysParamService.getByType(SysParamEnum.PASSWORD_TEACHER.getType());
        if (null == passwordGenerateType || null == passwordTeacher || "1".equals(passwordGenerateType.getValue())) {
            return new BCryptPasswordEncoder().encode((CharSequence)idNo.substring(idNo.length() - 6));
        }
        return new BCryptPasswordEncoder().encode((CharSequence)passwordTeacher.getValue());
    }
}

