/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.UserWrongReviewMapper;
import com.zsy.exam.model.entity.UserWrongReview;
import com.zsy.exam.service.IUserWrongReviewService;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserWrongReviewServiceImpl
extends ServiceImpl<UserWrongReviewMapper, UserWrongReview>
implements IUserWrongReviewService {
    @Autowired
    UserWrongReviewMapper userWrongReviewMapper;
    @Resource
    private RedisTemplate redisTemplate;

    public UserWrongReview getUserWrongReview(Long id) {
        return (UserWrongReview)this.userWrongReviewMapper.selectById((Serializable)id);
    }

    public Page<UserWrongReview> getAllUserWrongReview(Page page) {
        return (Page)this.userWrongReviewMapper.selectPage((IPage)page, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(Long wrongId) {
        Long userId = SecurityUtil.getUserId();
        String today = DateUtil.today();
        String key = "LOCK_EXERCISE_REVIEW_" + userId + "_" + today;
        long timeout = 3L;
        if (!this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)Boolean.TRUE, timeout, TimeUnit.SECONDS).booleanValue()) {
            throw new AppException("\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(UserWrongReview::getUserId, (Object)userId)).eq(UserWrongReview::getWrongId, (Object)wrongId)).eq(UserWrongReview::getDate, (Object)today);
        UserWrongReview db = (UserWrongReview)this.getOne((Wrapper)qw);
        if (null == db) {
            UserWrongReview view = new UserWrongReview();
            view.setUserId(userId);
            view.setWrongId(wrongId);
            view.setDate(today);
            view.setTotalCount(Integer.valueOf(1));
            ((UserWrongReviewMapper)this.baseMapper).insert((Object)view);
        } else {
            Integer totalCount = db.getTotalCount();
            db.setTotalCount(Integer.valueOf(totalCount + 1));
            this.updateById((Object)db);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(UserWrongReview userWrongReview) {
        return this.userWrongReviewMapper.updateById((Object)userWrongReview);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.userWrongReviewMapper.deleteBatchIds(Arrays.asList(array));
        }
    }
}

