/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.handler.WeChatLoginHandler;
import com.zsy.exam.model.dto.wx.QrCodeRep;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.vo.wx.QrCodeRes;
import com.zsy.exam.model.vo.wx.ScanStatusAuthRes;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.service.IWechatService;
import com.zsy.exam.service.WeChatMpService;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WechatServiceImpl
implements IWechatService {
    private static final Logger log = LoggerFactory.getLogger(WechatServiceImpl.class);
    @Autowired
    private IUserService userService;
    @Autowired
    private WeChatLoginHandler weChatLoginHandler;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private WeChatMpService wxMpService;
    private static final String TOKEN = "123456";
    private static final String createUrl = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=";
    private static final String showqrcodeUrl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=";

    public void wechatValidate(HttpServletRequest request, HttpServletResponse response) {
        String resultEchostr = "error";
        try {
            String signature = request.getParameter("signature");
            String timestamp = request.getParameter("timestamp");
            String nonce = request.getParameter("nonce");
            String echostr = request.getParameter("echostr");
            Object[] params = new String[]{timestamp, nonce, "123456"};
            Arrays.sort(params);
            String paramstr = (String)params[0] + (String)params[1] + (String)params[2];
            MessageDigest Sha1Dtgest = MessageDigest.getInstance("SHA-1");
            byte[] digestResult = Sha1Dtgest.digest(paramstr.getBytes("UTF-8"));
            String mysignature = WechatServiceImpl.bytes2HexString((byte[])digestResult);
            mysignature = mysignature.toLowerCase(Locale.ROOT);
            boolean signsuccess = mysignature.equals(signature);
            if (signsuccess) {
                resultEchostr = echostr;
            }
            response.getWriter().print(resultEchostr);
            response.getWriter().flush();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public QrCodeRes qrCodeCreate() {
        String accessToken = this.weChatLoginHandler.getAccessToken();
        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=" + accessToken;
        QrCodeRep codeRep = new QrCodeRep();
        codeRep.setAction_name("QR_STR_SCENE");
        codeRep.setExpire_seconds(Integer.valueOf(300));
        QrCodeRep.ActionInfo actionInfo = new QrCodeRep.ActionInfo();
        QrCodeRep.Scene scene = new QrCodeRep.Scene();
        String sceneStr = IdUtil.fastUUID();
        scene.setScene_str(sceneStr);
        actionInfo.setScene(scene);
        codeRep.setAction_info(actionInfo);
        String result = HttpUtil.post((String)url, (String)JSONUtil.toJsonStr((Object)codeRep));
        QrCodeRes res = (QrCodeRes)JSONUtil.toBean((String)result, QrCodeRes.class);
        res.setSceneStr(scene.getScene_str());
        try {
            String ticket = res.getTicket();
            String ticketUrl = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=" + URLEncoder.encode(ticket, "UTF-8");
            res.setTicketUrl(ticketUrl);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ScanStatusAuthRes authRes = new ScanStatusAuthRes();
        authRes.setStatus(Integer.valueOf(1));
        this.redisTemplate.opsForValue().set((Object)sceneStr, (Object)JSONUtil.toJsonStr((Object)authRes), (long)res.getExpire_seconds().intValue(), TimeUnit.SECONDS);
        return res;
    }

    public String receiveAndResponseMessage(HttpServletRequest request) throws Exception {
        Map map = WechatServiceImpl.parseXml((HttpServletRequest)request);
        String toUserName = (String)map.get("ToUserName");
        String fromUserName = (String)map.get("FromUserName");
        String createTime = (String)map.get("CreateTime");
        String msgType = (String)map.get("MsgType");
        String event = (String)map.get("Event");
        if (!msgType.equals("text") && !msgType.equals("image") && msgType.equals("event")) {
            if (event.equals("subscribe")) {
                String ticket = (String)map.get("Ticket");
                if (ticket != null) {
                    String eventKey = (String)map.get("EventKey");
                    String string = eventKey.replace("qrscene_", "");
                }
            } else if (event.equals("SCAN")) {
                String eventKey;
                log.info("\u626b\u7801\u6210\u529f {}", (Object)map);
                String ticket = (String)map.get("Ticket");
                if (ticket != null && StringUtils.isNotBlank((CharSequence)(eventKey = (String)map.get("EventKey")))) {
                    this.handleLogin(fromUserName, eventKey);
                }
            } else if (event.equals("unsubscribe")) {
                log.info("\u53d6\u6d88\u5173\u6ce8");
                String string = fromUserName;
            } else if (event.equals("CLICK")) {
                // empty if block
            }
        }
        return "";
    }

    public ScanStatusAuthRes scanStatus(String sceneStr) {
        if (!this.redisTemplate.hasKey((Object)sceneStr).booleanValue()) {
            throw new AppException("\u626b\u7801\u767b\u5f55\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u4e8c\u7ef4\u7801!");
        }
        Object o = this.redisTemplate.opsForValue().get((Object)sceneStr);
        if (o == null) {
            throw new AppException("\u626b\u7801\u767b\u5f55\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u4e8c\u7ef4\u7801!");
        }
        ScanStatusAuthRes authRes = (ScanStatusAuthRes)JSONUtil.toBean((String)o.toString(), ScanStatusAuthRes.class);
        if (authRes.getStatus() == 2) {
            // empty if block
        }
        return authRes;
    }

    public void handleLogin(String openId, String sceneStr) {
        if (!this.redisTemplate.hasKey((Object)sceneStr).booleanValue()) {
            throw new AppException("\u626b\u7801\u767b\u5f55\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u4e8c\u7ef4\u7801!");
        }
        Object o = this.redisTemplate.opsForValue().get((Object)sceneStr);
        if (o == null) {
            throw new AppException("\u626b\u7801\u767b\u5f55\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u4e8c\u7ef4\u7801!");
        }
        ScanStatusAuthRes authRes = (ScanStatusAuthRes)JSONUtil.toBean((String)o.toString(), ScanStatusAuthRes.class);
        User user = (User)this.userService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getWechatOpenId, (Object)openId)).eq(User::getIsDeleted, (Object)false));
        if (user == null) {
            authRes.setStatus(Integer.valueOf(3));
        } else {
            authRes.setStatus(Integer.valueOf(2));
        }
        authRes.setOpenId(openId);
        authRes.setQrScene(sceneStr);
        long expire = this.redisTemplate.getExpire((Object)sceneStr);
        this.redisTemplate.opsForValue().set((Object)sceneStr, (Object)JSONUtil.toJsonStr((Object)authRes), expire, TimeUnit.SECONDS);
    }

    public static Map<String, String> parseXml(HttpServletRequest request) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        ServletInputStream inputStream = request.getInputStream();
        SAXReader reader = new SAXReader();
        Document document = reader.read((InputStream)inputStream);
        Element root = document.getRootElement();
        List elementList = root.elements();
        for (Element e : elementList) {
            map.put(e.getName(), e.getText());
        }
        inputStream.close();
        inputStream = null;
        return map;
    }

    public static String bytes2HexString(byte[] b) {
        Object r = "";
        for (int i = 0; i < b.length; ++i) {
            Object hex = Integer.toHexString(b[i] & 0xFF);
            if (((String)hex).length() == 1) {
                hex = "0" + (String)hex;
            }
            r = (String)r + ((String)hex).toUpperCase();
        }
        return r;
    }
}

