/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.mapper.WrongQuestionBookMapper;
import com.zsy.exam.model.dto.ExamUserWrongDTO;
import com.zsy.exam.model.dto.UpdateStatusDTO;
import com.zsy.exam.model.dto.WrongQuestionBookAddDTO;
import com.zsy.exam.model.dto.exercise.AnswerProcessDto;
import com.zsy.exam.model.entity.ExamQuAnswer;
import com.zsy.exam.model.entity.ExerciseRecord;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.WrongQuestionBook;
import com.zsy.exam.model.vo.ExamUserWrongVO;
import com.zsy.exam.model.vo.QuestionVO;
import com.zsy.exam.model.vo.WrongQuestionBookDetailVO;
import com.zsy.exam.model.vo.WrongQuestionBookExamVO;
import com.zsy.exam.model.vo.WrongQuestionBookKnowledgeVO;
import com.zsy.exam.model.vo.WrongQuestionBookVO;
import com.zsy.exam.service.IExamQuAnswerService;
import com.zsy.exam.service.IExerciseRecordService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IWrongQuestionBookService;
import com.zsy.exam.util.DateTimeUtil;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class WrongQuestionBookServiceImpl
extends ServiceImpl<WrongQuestionBookMapper, WrongQuestionBook>
implements IWrongQuestionBookService {
    @Autowired
    WrongQuestionBookMapper wrongQuestionBookMapper;
    @Autowired
    private IQuestionService questionService;
    @Autowired
    private IExerciseRecordService exerciseRecordService;
    @Autowired
    private IExamQuAnswerService examQuAnswerService;

    public List<WrongQuestionBookDetailVO> detailByExercise(Long id) {
        ArrayList<WrongQuestionBookDetailVO> questionVOS = new ArrayList<WrongQuestionBookDetailVO>();
        Long userId = SecurityUtil.getUserId();
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WrongQuestionBook::getRelationId, (Object)id)).eq(WrongQuestionBook::getUserId, (Object)userId)).eq(WrongQuestionBook::getType, (Object)2));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return questionVOS;
        }
        for (WrongQuestionBook book : list) {
            QuestionVO questionVO = this.questionService.detailByWrongBook(book.getQuestionId());
            ExerciseRecord exerciseRecord = (ExerciseRecord)this.exerciseRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExerciseRecord::getExerciseId, (Object)book.getRelationId())).eq(ExerciseRecord::getUserId, (Object)book.getUserId())).eq(ExerciseRecord::getIsDeleted, (Object)0));
            if (null == exerciseRecord) continue;
            AnswerProcessDto answerProcess = this.getAnswerProcess(exerciseRecord.getAnswerProcess(), book.getQuestionId());
            WrongQuestionBookDetailVO vo = new WrongQuestionBookDetailVO();
            vo.setQuestionVO(questionVO);
            vo.setAnswerProcessDto(answerProcess);
            vo.setIsCollect(book.getIsCollect());
            vo.setId(book.getId());
            questionVOS.add(vo);
        }
        return questionVOS;
    }

    public List<WrongQuestionBookDetailVO> detailByKnowledge(Long id, Integer type) {
        if (null == type) {
            type = 2;
        }
        ArrayList<WrongQuestionBookDetailVO> questionVOS = new ArrayList<WrongQuestionBookDetailVO>();
        Long userId = SecurityUtil.getUserId();
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WrongQuestionBook::getRepoId, (Object)id)).eq(WrongQuestionBook::getUserId, (Object)userId)).eq(WrongQuestionBook::getType, (Object)type));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return questionVOS;
        }
        for (WrongQuestionBook book : list) {
            QuestionVO questionVO = this.questionService.detailByWrongBook(book.getQuestionId());
            WrongQuestionBookDetailVO vo = new WrongQuestionBookDetailVO();
            if (Integer.valueOf(1).equals(type)) {
                AnswerProcessDto answerProcess = this.getExamAnswerProcess(book);
                vo.setAnswerProcessDto(answerProcess);
            } else {
                ExerciseRecord exerciseRecord = (ExerciseRecord)this.exerciseRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExerciseRecord::getExerciseId, (Object)book.getRelationId())).eq(ExerciseRecord::getUserId, (Object)book.getUserId())).eq(ExerciseRecord::getIsDeleted, (Object)0));
                if (null == exerciseRecord) continue;
                AnswerProcessDto answerProcess = this.getAnswerProcess(exerciseRecord.getAnswerProcess(), book.getQuestionId());
                vo.setAnswerProcessDto(answerProcess);
            }
            vo.setQuestionVO(questionVO);
            vo.setIsCollect(book.getIsCollect());
            vo.setId(book.getId());
            questionVOS.add(vo);
        }
        return questionVOS;
    }

    public List<WrongQuestionBookDetailVO> detailByExam(Long id) {
        ArrayList<WrongQuestionBookDetailVO> questionVOS = new ArrayList<WrongQuestionBookDetailVO>();
        Long userId = SecurityUtil.getUserId();
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WrongQuestionBook::getRelationId, (Object)id)).eq(WrongQuestionBook::getUserId, (Object)userId)).eq(WrongQuestionBook::getType, (Object)1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return questionVOS;
        }
        for (WrongQuestionBook book : list) {
            QuestionVO questionVO = this.questionService.detailByWrongBook(book.getQuestionId());
            WrongQuestionBookDetailVO vo = new WrongQuestionBookDetailVO();
            AnswerProcessDto answerProcess = this.getExamAnswerProcess(book);
            vo.setAnswerProcessDto(answerProcess);
            vo.setQuestionVO(questionVO);
            vo.setIsCollect(book.getIsCollect());
            vo.setId(book.getId());
            questionVOS.add(vo);
        }
        return questionVOS;
    }

    public Page<WrongQuestionBookVO> exercisePage(Page page, String key, Long userId) {
        if (null == userId) {
            userId = SecurityUtil.getUserId();
        }
        Page bookVOPage = ((WrongQuestionBookMapper)this.baseMapper).queryPageExercise(page, key, userId);
        return bookVOPage;
    }

    public Page<WrongQuestionBookKnowledgeVO> knowledgePage(Page page, String key, Integer type, Long userId) {
        if (null == type) {
            type = 2;
        }
        if (null == userId) {
            userId = SecurityUtil.getUserId();
        }
        Page bookVOPage = ((WrongQuestionBookMapper)this.baseMapper).queryPageKnowledge(page, key, userId, type);
        return bookVOPage;
    }

    public Page<WrongQuestionBookExamVO> examPage(Page page, String key) {
        Long userId = SecurityUtil.getUserId();
        Page bookVOPage = ((WrongQuestionBookMapper)this.baseMapper).examPage(page, key, userId);
        return bookVOPage;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(WrongQuestionBookAddDTO dto) {
        if (dto == null || dto.getId() != null) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        WrongQuestionBook wrongQuestionBook = new WrongQuestionBook();
        BeanUtils.copyProperties((Object)dto, (Object)wrongQuestionBook);
        Question question = (Question)this.questionService.getById((Serializable)dto.getQuestionId());
        wrongQuestionBook.setRepoId(question.getRepoId());
        wrongQuestionBook.setUserId(SecurityUtil.getUserId());
        this.wrongQuestionBookMapper.insert((Object)wrongQuestionBook);
    }

    @Transactional(rollbackFor={Exception.class})
    public void addBatch(List<WrongQuestionBookAddDTO> dtos, Long relationId) {
        Long userId = SecurityUtil.getUserId();
        ((WrongQuestionBookMapper)this.baseMapper).actualDelByRelationId(relationId, userId);
        if (CollUtil.isNotEmpty(dtos)) {
            dtos.forEach(arg_0 -> this.add(arg_0));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(WrongQuestionBook wrongQuestionBook) {
        return this.wrongQuestionBookMapper.updateById((Object)wrongQuestionBook);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array = ids.split(",");
        if (!CollectionUtils.isEmpty(Arrays.asList(array))) {
            this.wrongQuestionBookMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public void updateCollect(UpdateStatusDTO dto) {
        WrongQuestionBook wrongQuestionBook = (WrongQuestionBook)this.getById((Serializable)dto.getId());
        if (null == wrongQuestionBook) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        wrongQuestionBook.setIsCollect(dto.getStatus());
        this.updateById((Object)wrongQuestionBook);
    }

    public Page<ExamUserWrongVO> getExamUserWrongList(Page page, ExamUserWrongDTO dto) {
        Date date = null;
        date = dto.getDateType() == null || dto.getDateType() == 1 ? DateTimeUtil.addMonth((Date)new Date(), (int)-3) : DateTimeUtil.addMonth((Date)new Date(), (int)-6);
        Page examUserWrongVOPage = this.wrongQuestionBookMapper.queryPageUserExam(page, dto, date);
        return examUserWrongVOPage;
    }

    public Page<WrongQuestionBookVO> exerciseClbumPage(Page page, String key, Long clbumId) {
        Page bookVOPage = ((WrongQuestionBookMapper)this.baseMapper).queryPageClbumExercise(page, key, clbumId);
        return bookVOPage;
    }

    public Page<WrongQuestionBookKnowledgeVO> knowledgeClbumPage(Page page, String key, Long clbumId, Integer type) {
        if (null == type) {
            type = 2;
        }
        Page bookVOPage = ((WrongQuestionBookMapper)this.baseMapper).queryPageClbumKnowledge(page, key, clbumId, type);
        return bookVOPage;
    }

    AnswerProcessDto getAnswerProcess(String answerProcess, Long quId) {
        if (StrUtil.isNotBlank((CharSequence)answerProcess)) {
            List answerProcessDtos = JSONUtil.toList((String)answerProcess, AnswerProcessDto.class);
            for (AnswerProcessDto answer : answerProcessDtos) {
                String qu = answer.getQuId();
                if (!qu.equals(quId.toString())) continue;
                return answer;
            }
        }
        return null;
    }

    private AnswerProcessDto getExamAnswerProcess(WrongQuestionBook book) {
        ExamQuAnswer examQuAnswer = (ExamQuAnswer)this.examQuAnswerService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExamQuAnswer::getExamId, (Object)book.getRelationId())).eq(ExamQuAnswer::getUserId, (Object)book.getUserId())).eq(ExamQuAnswer::getQuestionId, (Object)book.getQuestionId()));
        AnswerProcessDto answerProcess = new AnswerProcessDto();
        if (null != examQuAnswer) {
            List objective = QuestionTypeEnum.getObjective();
            if (objective.contains(examQuAnswer.getQuestionType().getType())) {
                answerProcess.setAnswer(examQuAnswer.getAnswerId());
            } else {
                answerProcess.setAnswer(examQuAnswer.getAnswerContent());
            }
            answerProcess.setIsRight(Boolean.valueOf(Integer.valueOf(1).equals(examQuAnswer.getIsRight())));
            answerProcess.setQuId(StrUtil.toString((Object)examQuAnswer.getQuestionId()));
        }
        return answerProcess;
    }
}

