/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.ExamStudentTeacherMappingMapper;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExamStudentTeacherMapping;
import com.zsy.exam.service.IUserMessageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ExamNoticeTask {
    private static final Logger log = LoggerFactory.getLogger(ExamNoticeTask.class);
    @Autowired
    private ExamMapper examMapper;
    @Autowired
    private ExamStudentTeacherMappingMapper examStudentTeacherMappingMapper;
    @Autowired
    private IUserMessageService userMessageService;

    @Scheduled(cron="0 0/1 * * * ?")
    public void setEffectiveExpire() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String date = format.format((Object)DateUtils.addSeconds((Date)new Date(), (int)2));
        List exams = this.examMapper.getExamByEndTime(date);
        log.info("\u5f00\u59cb\u6267\u884c,\u6267\u884c\u4efb\u52a1\u6570\u636e:" + String.valueOf(exams));
        log.info("\u65f6\u95f4\uff1a" + date);
        if (CollectionUtils.isEmpty((Collection)exams)) {
            return;
        }
        log.info("\u6267\u884c\u8003\u8bd5\u901a\u77e5\u4efb\u52a1");
        for (Exam exam : exams) {
            List examStudentTeacherMappings = this.examStudentTeacherMappingMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExamStudentTeacherMapping::getExamId, (Object)exam.getId()));
            if (CollectionUtils.isEmpty((Collection)examStudentTeacherMappings)) continue;
            Set userIds = examStudentTeacherMappings.stream().map(ExamStudentTeacherMapping::getUserId).collect(Collectors.toSet());
            ArrayList list = new ArrayList();
            list.addAll(userIds);
            this.userMessageService.sendMessageExam(exam, list);
            log.info("\u6267\u884c\u8003\u8bd5\u901a\u77e5\u8003\u8bd5id:" + exam.getId());
        }
        log.info("\u6267\u884c\u8003\u8bd5\u901a\u77e5\u7ed3\u675f");
    }
}

