/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.service.ISM2Service;
import com.zsy.exam.service.ISysParamService;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RegionServeTask {
    private static final Logger log = LoggerFactory.getLogger(RegionServeTask.class);
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private ISM2Service sm2Service;
    public static String REDIS_REGION_CONNECTION_TIME = "REDIS_REGION_CONNECTION_TIME";

    @Scheduled(cron="0 0/5 * * * ?")
    public void regionConnection() {
        SysParam serviceIpSys = this.sysParamService.getByType(SysParamEnum.REGION_SERVE_IP.getType());
        String encrypt = this.sm2Service.encrypt(null, null);
        String ip = serviceIpSys.getValue();
        String url = ip + "/school/region/connection?sign=" + encrypt;
        try {
            int randomSleepTime = ThreadLocalRandom.current().nextInt(0, 5000);
            Thread.sleep(randomSleepTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String s = HttpUtil.get((String)url);
        Result result = (Result)JSONUtil.toBean((String)s, Result.class);
        log.info("ping \u4e3b\u673a:" + url + ", \u8fd4\u56de" + s);
        if (Result.isSuccess((Result)result).booleanValue()) {
            this.redisTemplate.opsForValue().set((Object)REDIS_REGION_CONNECTION_TIME, (Object)DateUtil.now());
        }
    }
}

