/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.model.entity.RedisData;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CacheClient {
    private static final Logger log = LoggerFactory.getLogger(CacheClient.class);
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    private Random random = new Random();
    private static final ExecutorService CACHE_REBUILD_EXECUTOR = Executors.newFixedThreadPool(10);

    public void set(String key, Object value, Long time, TimeUnit unit) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)value), time.longValue(), unit);
    }

    public void setWithLogicalExpire(String key, Object value, Long time, TimeUnit unit) {
        RedisData redisData = new RedisData();
        redisData.setData(value);
        redisData.setExpireTime(LocalDateTime.now().plusSeconds(unit.toSeconds(time)));
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)JSONUtil.toJsonStr((Object)redisData));
    }

    public <R, ID, T> R queryWithPassThrough(String keyPrefix, ID id, Class<R> type, Function<ID, R> dbFallback, Class<T> voClass, Long time, TimeUnit unit) {
        String key = keyPrefix + String.valueOf(id);
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isNotBlank((CharSequence)json)) {
            if (type.equals(IPage.class)) {
                JSONObject jsonObject = JSONUtil.parseObj((String)json);
                List dataList = JSONUtil.toList((JSONArray)jsonObject.getJSONArray((Object)"records"), voClass);
                Page page = new Page();
                page.setRecords(dataList);
                page.setTotal((long)jsonObject.getInt((Object)"total").intValue());
                page.setSize((long)jsonObject.getInt((Object)"size").intValue());
                page.setCurrent((long)jsonObject.getInt((Object)"current").intValue());
                return (R)page;
            }
            if (type.equals(List.class)) {
                List clbumVOList = JSONUtil.toList((String)json, voClass);
                return (R)clbumVOList;
            }
            return (R)JSONUtil.toBean((String)json, type);
        }
        if (json != null) {
            return null;
        }
        R r = dbFallback.apply(id);
        if (r == null) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)"", 2L, TimeUnit.MINUTES);
            return null;
        }
        String shopTOJson = JSONUtil.toJsonStr(r);
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)shopTOJson, time + (long)this.random.nextInt(20), unit);
        return r;
    }

    public <R, ID> R queryWithLogicalExpire(String keyPrefix, ID id, Class<R> type, Function<ID, R> dbFallback, Long time, TimeUnit unit) {
        String key = keyPrefix + String.valueOf(id);
        String json = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StrUtil.isBlank((CharSequence)json)) {
            return null;
        }
        RedisData redisData = (RedisData)JSONUtil.toBean((String)json, RedisData.class);
        JSONObject shopData = (JSONObject)redisData.getData();
        Object r = JSONUtil.toBean((JSONObject)shopData, type);
        LocalDateTime expireTime = redisData.getExpireTime();
        if (expireTime.isAfter(LocalDateTime.now())) {
            return (R)r;
        }
        String lockKey = "lock:shop:" + String.valueOf(id);
        boolean isLock = this.tryLock(lockKey);
        if (isLock) {
            json = (String)this.stringRedisTemplate.opsForValue().get((Object)("cache:shop:" + String.valueOf(id)));
            redisData = (RedisData)JSONUtil.toBean((String)json, RedisData.class);
            shopData = (JSONObject)redisData.getData();
            r = JSONUtil.toBean((JSONObject)shopData, type);
            expireTime = redisData.getExpireTime();
            if (expireTime.isAfter(LocalDateTime.now())) {
                return (R)r;
            }
            CACHE_REBUILD_EXECUTOR.submit(() -> {
                try {
                    Object r1 = dbFallback.apply(id);
                    this.setWithLogicalExpire(key, r1, Long.valueOf(time + (long)this.random.nextInt(20)), unit);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.unlock(lockKey);
                }
            });
        }
        return (R)r;
    }

    private boolean tryLock(String key) {
        Boolean flag = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)"1", 10L, TimeUnit.SECONDS);
        return BooleanUtil.isTrue((Boolean)flag);
    }

    private void unlock(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    public <T> Map<Long, T> batchGet(String prefix, List<Long> keys, Class<T> clazz) {
        try {
            List stringKeys = keys.stream().map(key -> prefix + key.toString()).collect(Collectors.toList());
            List values = this.stringRedisTemplate.opsForValue().multiGet(stringKeys);
            HashMap<Long, Object> resultMap = new HashMap<Long, Object>();
            for (int i = 0; i < stringKeys.size(); ++i) {
                String value = (String)values.get(i);
                if (value == null) continue;
                Object deserializedObject = CacheClient.deserialize((String)value, clazz);
                resultMap.put(keys.get(i), deserializedObject);
            }
            return resultMap;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to batch get from Redis", e);
        }
    }

    private static <T> T deserialize(String value, Class<T> clazz) {
        return (T)JSONUtil.toBean((String)value, clazz);
    }

    public <K, V> void batchPut(String prefix, Map<K, V> data, long expireTime, TimeUnit timeUnit) {
        ArrayList<Object> allArgs = new ArrayList<Object>();
        for (Map.Entry<K, V> entry : data.entrySet()) {
            String prefixedKey = prefix + entry.getKey().toString();
            allArgs.add(prefixedKey);
            allArgs.add(JSONUtil.toJsonStr(entry.getValue()));
            this.stringRedisTemplate.opsForValue().set((Object)prefixedKey, (Object)JSONUtil.toJsonStr(entry.getValue()), expireTime + (1L + this.random.nextLong(20L)), timeUnit);
        }
    }
}

