/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import com.zsy.exam.util.CryptoUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CryptoUtils {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static final Map<Algorithm, KeyFactory> KEY_FACTORY_CACHE = new ConcurrentHashMap();
    private static final Map<Algorithm, Cipher> CIPHER_CACHE = new HashMap();

    public static String generateSymmetricKey(Algorithm algorithm) throws NoSuchAlgorithmException {
        KeyGenerator generator = KeyGenerator.getInstance(algorithm.getName());
        generator.init(algorithm.getKeySize());
        SecretKey secretKey = generator.generateKey();
        return BASE64_ENCODER.encodeToString(secretKey.getEncoded());
    }

    public static AsymmetricKeyPair generateAsymmetricKeyPair(Algorithm algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm.getName());
        generator.initialize(algorithm.getKeySize());
        KeyPair keyPair = generator.generateKeyPair();
        String publicKey = BASE64_ENCODER.encodeToString(keyPair.getPublic().getEncoded());
        String privateKey = BASE64_ENCODER.encodeToString(keyPair.getPrivate().getEncoded());
        return new AsymmetricKeyPair(publicKey, privateKey);
    }

    public static String encryptByRSA(String publicKeyText, String plainText) throws Exception {
        return CryptoUtils.encryptAsymmetrically((String)publicKeyText, (String)plainText, (Algorithm)Algorithm.Encryption.RSA_ECB_PKCS1);
    }

    public static String decryptByRSA(String privateKeyText, String ciphertext) throws Exception {
        return CryptoUtils.decryptAsymmetrically((String)privateKeyText, (String)ciphertext, (Algorithm)Algorithm.Encryption.RSA_ECB_PKCS1);
    }

    public static String signBySHA1WithDSA(String privateKeyText, String msg) throws Exception {
        return CryptoUtils.doSign((String)privateKeyText, (String)msg, (Algorithm)Algorithm.Encryption.DSA, (Algorithm)Algorithm.Signing.SHA1WithDSA);
    }

    public static String signBySHA1WithRSA(String privateKeyText, String msg) throws Exception {
        return CryptoUtils.doSign((String)privateKeyText, (String)msg, (Algorithm)Algorithm.Encryption.RSA_ECB_PKCS1, (Algorithm)Algorithm.Signing.SHA1WithRSA);
    }

    public static String signBySHA256WithRSA(String privateKeyText, String msg) throws Exception {
        return CryptoUtils.doSign((String)privateKeyText, (String)msg, (Algorithm)Algorithm.Encryption.RSA_ECB_PKCS1, (Algorithm)Algorithm.Signing.SHA256WithRSA);
    }

    public static boolean verifyBySHA1WithDSA(String publicKeyText, String msg, String signatureText) throws Exception {
        return CryptoUtils.doVerify((String)publicKeyText, (String)msg, (String)signatureText, (Algorithm)Algorithm.Encryption.DSA, (Algorithm)Algorithm.Signing.SHA1WithDSA);
    }

    public static boolean verifyBySHA1WithRSA(String publicKeyText, String msg, String signatureText) throws Exception {
        return CryptoUtils.doVerify((String)publicKeyText, (String)msg, (String)signatureText, (Algorithm)Algorithm.Encryption.RSA_ECB_PKCS1, (Algorithm)Algorithm.Signing.SHA1WithRSA);
    }

    public static boolean verifyBySHA256WithRSA(String publicKeyText, String msg, String signatureText) throws Exception {
        return CryptoUtils.doVerify((String)publicKeyText, (String)msg, (String)signatureText, (Algorithm)Algorithm.Encryption.RSA_ECB_PKCS1, (Algorithm)Algorithm.Signing.SHA256WithRSA);
    }

    public static String encryptSymmetrically(String secretKey, String iv, String plainText, Algorithm algorithm) throws Exception {
        SecretKey key = CryptoUtils.decodeSymmetricKey((String)secretKey, (Algorithm)algorithm);
        IvParameterSpec ivParameterSpec = StringUtils.isBlank((CharSequence)iv) ? null : CryptoUtils.decodeIv((String)iv);
        byte[] plainTextInBytes = plainText.getBytes(DEFAULT_CHARSET);
        byte[] ciphertextInBytes = CryptoUtils.transform((Algorithm)algorithm, (int)1, (Key)key, (IvParameterSpec)ivParameterSpec, (byte[])plainTextInBytes);
        return BASE64_ENCODER.encodeToString(ciphertextInBytes);
    }

    public static String decryptSymmetrically(String secretKey, String iv, String ciphertext, Algorithm algorithm) throws Exception {
        SecretKey key = CryptoUtils.decodeSymmetricKey((String)secretKey, (Algorithm)algorithm);
        IvParameterSpec ivParameterSpec = StringUtils.isBlank((CharSequence)iv) ? null : CryptoUtils.decodeIv((String)iv);
        byte[] ciphertextInBytes = BASE64_DECODER.decode(ciphertext);
        byte[] plainTextInBytes = CryptoUtils.transform((Algorithm)algorithm, (int)2, (Key)key, (IvParameterSpec)ivParameterSpec, (byte[])ciphertextInBytes);
        return new String(plainTextInBytes, DEFAULT_CHARSET);
    }

    public static String encryptAsymmetrically(String publicKeyText, String plainText, Algorithm algorithm) throws Exception {
        PublicKey publicKey = CryptoUtils.regeneratePublicKey((String)publicKeyText, (Algorithm)algorithm);
        byte[] plainTextInBytes = plainText.getBytes(DEFAULT_CHARSET);
        byte[] ciphertextInBytes = CryptoUtils.transform((Algorithm)algorithm, (int)1, (Key)publicKey, (byte[])plainTextInBytes);
        return BASE64_ENCODER.encodeToString(ciphertextInBytes);
    }

    public static String decryptAsymmetrically(String privateKeyText, String ciphertext, Algorithm algorithm) throws Exception {
        PrivateKey privateKey = CryptoUtils.regeneratePrivateKey((String)privateKeyText, (Algorithm)algorithm);
        byte[] ciphertextInBytes = BASE64_DECODER.decode(ciphertext);
        byte[] plainTextInBytes = CryptoUtils.transform((Algorithm)algorithm, (int)2, (Key)privateKey, (byte[])ciphertextInBytes);
        return new String(plainTextInBytes, DEFAULT_CHARSET);
    }

    public static String doSign(String privateKeyText, String msg, Algorithm encryptionAlgorithm, Algorithm signatureAlgorithm) throws Exception {
        PrivateKey privateKey = CryptoUtils.regeneratePrivateKey((String)privateKeyText, (Algorithm)encryptionAlgorithm);
        Signature signature = Signature.getInstance(signatureAlgorithm.getName());
        signature.initSign(privateKey);
        signature.update(msg.getBytes(DEFAULT_CHARSET));
        byte[] signatureInBytes = signature.sign();
        return BASE64_ENCODER.encodeToString(signatureInBytes);
    }

    public static boolean doVerify(String publicKeyText, String msg, String signatureText, Algorithm encryptionAlgorithm, Algorithm signatureAlgorithm) throws Exception {
        PublicKey publicKey = CryptoUtils.regeneratePublicKey((String)publicKeyText, (Algorithm)encryptionAlgorithm);
        Signature signature = Signature.getInstance(signatureAlgorithm.getName());
        signature.initVerify(publicKey);
        signature.update(msg.getBytes(DEFAULT_CHARSET));
        return signature.verify(BASE64_DECODER.decode(signatureText));
    }

    private static SecretKey decodeSymmetricKey(String secretKey, Algorithm algorithm) {
        byte[] key = BASE64_DECODER.decode(secretKey);
        return new SecretKeySpec(key, algorithm.getName());
    }

    private static IvParameterSpec decodeIv(String iv) {
        byte[] ivInBytes = BASE64_DECODER.decode(iv);
        return new IvParameterSpec(ivInBytes);
    }

    private static PublicKey regeneratePublicKey(String publicKeyText, Algorithm algorithm) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyInBytes = BASE64_DECODER.decode(publicKeyText);
        KeyFactory keyFactory = CryptoUtils.getKeyFactory((Algorithm)algorithm);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(keyInBytes);
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return publicKey;
    }

    private static PrivateKey regeneratePrivateKey(String key, Algorithm algorithm) throws Exception {
        byte[] keyInBytes = BASE64_DECODER.decode(key);
        KeyFactory keyFactory = CryptoUtils.getKeyFactory((Algorithm)algorithm);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keyInBytes);
        PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
        return privateKey;
    }

    private static KeyFactory getKeyFactory(Algorithm algorithm) throws NoSuchAlgorithmException {
        KeyFactory keyFactory = (KeyFactory)KEY_FACTORY_CACHE.get(algorithm);
        if (keyFactory == null) {
            keyFactory = KeyFactory.getInstance(algorithm.getName());
            KEY_FACTORY_CACHE.put(algorithm, keyFactory);
        }
        return keyFactory;
    }

    private static byte[] transform(Algorithm algorithm, int mode, Key key, byte[] msg) throws Exception {
        return CryptoUtils.transform((Algorithm)algorithm, (int)mode, (Key)key, null, (byte[])msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transform(Algorithm algorithm, int mode, Key key, IvParameterSpec iv, byte[] msg) throws Exception {
        Cipher cipher = (Cipher)CIPHER_CACHE.get(algorithm);
        if (cipher == null) {
            Class<CryptoUtils> clazz = CryptoUtils.class;
            synchronized (CryptoUtils.class) {
                cipher = (Cipher)CIPHER_CACHE.get(algorithm);
                if (cipher == null) {
                    cipher = CryptoUtils.determineWhichCipherToUse((Algorithm)algorithm);
                    CIPHER_CACHE.put(algorithm, cipher);
                }
                cipher.init(mode, key, iv);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return cipher.doFinal(msg);
            }
        }
        Class<CryptoUtils> clazz = CryptoUtils.class;
        synchronized (CryptoUtils.class) {
            cipher.init(mode, key, iv);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            return cipher.doFinal(msg);
        }
    }

    private static Cipher determineWhichCipherToUse(Algorithm algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String transformation = algorithm.getTransformation();
        Cipher cipher = StringUtils.isNotEmpty((CharSequence)transformation) ? Cipher.getInstance(transformation) : Cipher.getInstance(algorithm.getName());
        return cipher;
    }
}

