/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import com.sun.mail.util.MailSSLSocketFactory;
import com.zsy.exam.model.vo.EmailManangerVO;
import com.zsy.exam.service.IEmailManagerService;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    @Autowired
    private IEmailManagerService emailManagerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEmail(String toEmailAddress, String emailTitle, String emailContent) {
        EmailManangerVO emailManangerVO = this.emailManagerService.get();
        Transport transport = null;
        if (emailManangerVO == null) {
            log.info("\u6ca1\u914d\u7f6e\u90ae\u7bb1\u670d\u52a1\u5668,\u4e0d\u80fd\u53d1\u9001\u90ae\u4ef6");
            return;
        }
        try {
            Properties props = new Properties();
            props.setProperty("mail.smtp.auth", "true");
            props.put("mail.smtp.port", (Object)465);
            props.setProperty("mail.smtp.host", emailManangerVO.getHostName());
            props.setProperty("mail.transport.protocol", "smtp");
            MailSSLSocketFactory sf = new MailSSLSocketFactory();
            sf.setTrustAllHosts(true);
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.ssl.socketFactory", sf);
            Session session = Session.getInstance((Properties)props);
            MimeMessage msg = new MimeMessage(session);
            msg.setSubject(emailManangerVO.getPrefixTitle() + emailTitle);
            msg.setSentDate(new Date());
            msg.setText(emailContent, "UTF-8", "html");
            msg.setFrom((Address)new InternetAddress(emailManangerVO.getEmailName(), emailManangerVO.getNickname(), "UTF-8"));
            transport = session.getTransport();
            transport.connect(emailManangerVO.getHostName(), emailManangerVO.getEmailName(), emailManangerVO.getEmailPassword());
            transport.sendMessage((Message)msg, new Address[]{new InternetAddress(toEmailAddress)});
        }
        catch (Exception e) {
            log.error("\u90ae\u4ef6\u53d1\u9001\u9519\u8bef", (Throwable)e);
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String emailTemp(String s, Integer code) {
        return "111";
    }

    public static void main(String[] args) {
        String s = "\u8fd9\u662femailUtil\u7684\u6d4b\u8bd5\u90ae\u4ef6";
        EmailUtil emailUtil = new EmailUtil();
        emailUtil.sendEmail("xuran1993157@163.com", "emailUtil\u6d4b\u8bd5", s);
    }
}

