/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zsy.exam.mapper.RoleMapper;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtUtil.class);
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private RoleMapper roleMapper;
    @Value(value="${jwt.secret}")
    private String secret;

    public String createJwt(String userInfo, List<String> authList) {
        Date issDate = new Date();
        Date expireDate = new Date(issDate.getTime() + 86400000L);
        HashMap<String, String> headerClaims = new HashMap<String, String>();
        headerClaims.put("alg", "HS256");
        headerClaims.put("typ", "JWT");
        return JWT.create().withHeader(headerClaims).withIssuer("wj").withIssuedAt(issDate).withExpiresAt(expireDate).withClaim("userInfo", userInfo).withClaim("authList", authList).sign(Algorithm.HMAC256((String)this.secret));
    }

    public boolean verifyToken(String token) {
        JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)this.secret)).build();
        try {
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException e) {
            log.error("\u6821\u9a8c\u5931\u8d25");
            return false;
        }
    }

    public String getUser(String token) {
        JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)this.secret)).build();
        try {
            DecodedJWT jwt = verifier.verify(token);
            return jwt.getClaim("userInfo").asString();
        }
        catch (JWTVerificationException e) {
            log.error("\u7528\u6237\u83b7\u53d6\u5931\u8d25");
            return null;
        }
    }

    public List<String> getAuthList(String token) {
        JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)this.secret)).build();
        try {
            DecodedJWT jwt = verifier.verify(token);
            List roleCodes = jwt.getClaim("authList").asList(String.class);
            HashSet sets = new HashSet();
            if (CollectionUtils.isEmpty((Collection)roleCodes)) {
                return sets.stream().toList();
            }
            for (String code : roleCodes) {
                Map entries = this.stringRedisTemplate.opsForHash().entries((Object)code);
                if (null == entries || entries.isEmpty()) continue;
                Set collect = entries.entrySet().stream().filter(item -> null != item.getValue() && StringUtils.isNotBlank((CharSequence)item.getValue().toString())).map(Map.Entry::getValue).map(Object::toString).collect(Collectors.toSet());
                sets.addAll(collect);
            }
            return sets.stream().toList();
        }
        catch (JWTVerificationException e) {
            log.error("\u6743\u9650\u5217\u8868+\u83b7\u53d6\u5931\u8d25");
            return null;
        }
    }
}

