/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import cn.hutool.core.codec.Base64Decoder;
import cn.hutool.core.codec.Base64Encoder;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.model.dto.PicDto;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.PutObjectOptions;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class MinioUtil {
    @Value(value="${minio.endpointView}")
    private String endpointView;
    @Value(value="${minio.sys-bucket}")
    private String sysBucket;
    @Value(value="${minio.expert-question-bucket}")
    private String expertBucket;
    @Value(value="${minio.teacher-question-bucket}")
    private String teacherBucket;
    @Value(value="${minio.student-bucket}")
    private String studentBucket;
    @Value(value="${minio.school-shuxue-bucket}")
    private String shuxueBucket;
    @Autowired
    private MinioClient minioClient;
    public static final String TEMP_PATH = System.getProperty("java.io.tmpdir");

    public String upload(MultipartFile file, Integer type) throws Exception {
        String bucketName = this.getBucketNameByType(type);
        InputStream inputStream = file.getInputStream();
        String originalFilename = file.getOriginalFilename();
        assert (originalFilename != null) : "\u4e0a\u4f20\u6587\u4ef6\u65f6\u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25\uff0c\u4e3anull";
        String fileName = String.valueOf(UUID.randomUUID()) + originalFilename.substring(originalFilename.lastIndexOf("."));
        this.minioClient.putObject(bucketName, fileName, inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
        return String.format("%s/%s/%s", this.endpointView, bucketName, fileName);
    }

    public String upload(InputStream inputStream, String originalFilename, Integer type) throws Exception {
        String bucketName = this.getBucketNameByType(type);
        assert (originalFilename != null) : "\u4e0a\u4f20\u6587\u4ef6\u65f6\u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25\uff0c\u4e3anull";
        String fileName = String.valueOf(UUID.randomUUID()) + originalFilename.substring(originalFilename.lastIndexOf("."));
        try {
            this.minioClient.putObject(bucketName, fileName, inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
        }
        catch (Exception e) {
            throw new AppException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
        }
        finally {
            inputStream.close();
        }
        return String.format("%s/%s/%s", this.endpointView, bucketName, fileName);
    }

    public void upload(PicDto dto) {
        try {
            String base64 = dto.getBase64();
            if (null != base64) {
                byte[] decode = Base64Decoder.decode((CharSequence)base64);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(decode);
                this.minioClient.putObject(dto.getBucketName(), dto.getPicName(), (InputStream)inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void download(HttpServletResponse response, String fileName) {
        InputStream in = null;
        try {
            ObjectStat stat = this.minioClient.statObject(this.expertBucket, fileName);
            response.setContentType(stat.contentType());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            in = this.minioClient.getObject(this.expertBucket, fileName);
            IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String getBase64ByName(String bucketName, String fileName) {
        try {
            InputStream inputStream = this.minioClient.getObject(bucketName, fileName);
            byte[] bytes = inputStream.readAllBytes();
            if (bytes.length > 0) {
                return Base64Encoder.encode((byte[])bytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<PicDto> getPicBase64(List<String> urlList) {
        ArrayList<PicDto> re = new ArrayList<PicDto>();
        urlList = urlList.stream().distinct().toList();
        urlList.forEach(u -> {
            if (u.startsWith("/")) {
                u = u.substring(1);
            }
            String[] split = u.split("/");
            PicDto picDto = new PicDto();
            String bucketNam = split[1];
            String picName = split[2];
            picDto.setBucketName(bucketNam);
            picDto.setPicName(picName);
            String base64 = this.getBase64ByName(bucketNam, picName);
            picDto.setBase64(base64);
            re.add(picDto);
        });
        return re;
    }

    public boolean isImage(String filename) {
        String lastName = filename.substring(filename.lastIndexOf(".") + 1);
        String[] lastnames = new String[]{"png", "jpg", "jpeg", "bmp", "wmf"};
        return Arrays.asList(lastnames).contains(lastName);
    }

    public boolean isFile(String filename) {
        String lastName = filename.substring(filename.lastIndexOf(".") + 1);
        String[] lastnames = new String[]{"zip", "pdf", "doc", "docx", "txt", "xlsx", "pptx", "xls"};
        return Arrays.asList(lastnames).contains(lastName);
    }

    public boolean isOverSize(MultipartFile file) {
        return file.getSize() > 0x1400000L;
    }

    public String getBucketNameByType(Integer type) {
        String bucketName = null;
        switch (type) {
            case 0: {
                bucketName = this.sysBucket;
                break;
            }
            case 1: {
                bucketName = this.expertBucket;
                break;
            }
            case 2: {
                bucketName = this.teacherBucket;
                break;
            }
            case 3: {
                bucketName = this.studentBucket;
                break;
            }
            default: {
                bucketName = this.sysBucket;
            }
        }
        return bucketName;
    }

    public String getEndpointView() {
        return this.endpointView;
    }

    public String getSysBucket() {
        return this.sysBucket;
    }

    public String getExpertBucket() {
        return this.expertBucket;
    }

    public String getTeacherBucket() {
        return this.teacherBucket;
    }

    public String getStudentBucket() {
        return this.studentBucket;
    }

    public String getShuxueBucket() {
        return this.shuxueBucket;
    }

    public MinioClient getMinioClient() {
        return this.minioClient;
    }

    public void setEndpointView(String endpointView) {
        this.endpointView = endpointView;
    }

    public void setSysBucket(String sysBucket) {
        this.sysBucket = sysBucket;
    }

    public void setExpertBucket(String expertBucket) {
        this.expertBucket = expertBucket;
    }

    public void setTeacherBucket(String teacherBucket) {
        this.teacherBucket = teacherBucket;
    }

    public void setStudentBucket(String studentBucket) {
        this.studentBucket = studentBucket;
    }

    public void setShuxueBucket(String shuxueBucket) {
        this.shuxueBucket = shuxueBucket;
    }

    public void setMinioClient(MinioClient minioClient) {
        this.minioClient = minioClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MinioUtil)) {
            return false;
        }
        MinioUtil other = (MinioUtil)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$endpointView = this.getEndpointView();
        String other$endpointView = other.getEndpointView();
        if (this$endpointView == null ? other$endpointView != null : !this$endpointView.equals(other$endpointView)) {
            return false;
        }
        String this$sysBucket = this.getSysBucket();
        String other$sysBucket = other.getSysBucket();
        if (this$sysBucket == null ? other$sysBucket != null : !this$sysBucket.equals(other$sysBucket)) {
            return false;
        }
        String this$expertBucket = this.getExpertBucket();
        String other$expertBucket = other.getExpertBucket();
        if (this$expertBucket == null ? other$expertBucket != null : !this$expertBucket.equals(other$expertBucket)) {
            return false;
        }
        String this$teacherBucket = this.getTeacherBucket();
        String other$teacherBucket = other.getTeacherBucket();
        if (this$teacherBucket == null ? other$teacherBucket != null : !this$teacherBucket.equals(other$teacherBucket)) {
            return false;
        }
        String this$studentBucket = this.getStudentBucket();
        String other$studentBucket = other.getStudentBucket();
        if (this$studentBucket == null ? other$studentBucket != null : !this$studentBucket.equals(other$studentBucket)) {
            return false;
        }
        String this$shuxueBucket = this.getShuxueBucket();
        String other$shuxueBucket = other.getShuxueBucket();
        if (this$shuxueBucket == null ? other$shuxueBucket != null : !this$shuxueBucket.equals(other$shuxueBucket)) {
            return false;
        }
        MinioClient this$minioClient = this.getMinioClient();
        MinioClient other$minioClient = other.getMinioClient();
        return !(this$minioClient == null ? other$minioClient != null : !this$minioClient.equals(other$minioClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MinioUtil;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpointView = this.getEndpointView();
        result = result * 59 + ($endpointView == null ? 43 : $endpointView.hashCode());
        String $sysBucket = this.getSysBucket();
        result = result * 59 + ($sysBucket == null ? 43 : $sysBucket.hashCode());
        String $expertBucket = this.getExpertBucket();
        result = result * 59 + ($expertBucket == null ? 43 : $expertBucket.hashCode());
        String $teacherBucket = this.getTeacherBucket();
        result = result * 59 + ($teacherBucket == null ? 43 : $teacherBucket.hashCode());
        String $studentBucket = this.getStudentBucket();
        result = result * 59 + ($studentBucket == null ? 43 : $studentBucket.hashCode());
        String $shuxueBucket = this.getShuxueBucket();
        result = result * 59 + ($shuxueBucket == null ? 43 : $shuxueBucket.hashCode());
        MinioClient $minioClient = this.getMinioClient();
        result = result * 59 + ($minioClient == null ? 43 : $minioClient.hashCode());
        return result;
    }

    public String toString() {
        return "MinioUtil(endpointView=" + this.getEndpointView() + ", sysBucket=" + this.getSysBucket() + ", expertBucket=" + this.getExpertBucket() + ", teacherBucket=" + this.getTeacherBucket() + ", studentBucket=" + this.getStudentBucket() + ", shuxueBucket=" + this.getShuxueBucket() + ", minioClient=" + String.valueOf(this.getMinioClient()) + ")";
    }
}

