/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;

public class PinYinUtil {
    public static String chinese2PinYin(String chinese) {
        if (StringUtils.isBlank((CharSequence)chinese)) {
            return "";
        }
        Object pinyinStr = "";
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    pinyinStr = (String)pinyinStr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                    continue;
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return chinese;
                }
            }
            pinyinStr = (String)pinyinStr + newChar[i];
        }
        return pinyinStr;
    }

    public static String chinese2PinYinFirst(String chinese) {
        StringBuilder pinyin = new StringBuilder();
        for (char ch : chinese.toCharArray()) {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)ch);
            if (pinyinArray != null && pinyinArray.length > 0) {
                pinyin.append(pinyinArray[0].charAt(0));
                continue;
            }
            pinyin.append(ch);
        }
        return pinyin.toString();
    }
}

