/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import com.alibaba.fastjson2.JSON;
import com.zsy.exam.model.dto.sm2.SendDataOrigin;
import com.zsy.exam.model.dto.sm2.Sm2SendData;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.KeySpec;
import java.util.Base64;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class SM2Utils {
    public static KeyPair geneSM2KeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
        SecureRandom secureRandom = new SecureRandom();
        kpg.initialize(sm2Spec, secureRandom);
        KeyPair keyPair = kpg.generateKeyPair();
        return keyPair;
    }

    public static void geneSM2HexKeyPair() {
        try {
            KeyPair keyPair = SM2Utils.geneSM2KeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            System.out.println("========  EC X Y \u79d8\u94a5\u5bf9    ========");
            System.out.println(privateKey);
            System.out.println(publicKey);
            System.out.println("========  hex \u79d8\u94a5\u5bf9       ========");
            System.out.println("hex \u79c1\u94a5: " + SM2Utils.getPriKeyHexString((PrivateKey)privateKey));
            System.out.println("hex \u516c\u94a5: " + SM2Utils.getPubKeyHexString((PublicKey)publicKey));
            System.out.println("========  base64 \u79d8\u94a5\u5bf9    ========");
            System.out.println("base64 \u79c1\u94a5: " + new String(Base64.getEncoder().encode(privateKey.getEncoded())));
            System.out.println("base64 \u516c\u94a5: " + new String(Base64.getEncoder().encode(publicKey.getEncoded())));
            System.out.println("========  \u751f\u6210\u5b8c\u6210 ========");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getPriKeyHexString(PrivateKey privateKey) {
        BCECPrivateKey key = (BCECPrivateKey)privateKey;
        BigInteger intPrivateKey = key.getD();
        String priKeyHexString = intPrivateKey.toString(16);
        return priKeyHexString;
    }

    public static String getPriKeyBase64String(PrivateKey privateKey) {
        return new String(Base64.getEncoder().encode(privateKey.getEncoded()));
    }

    public static String getPubKeyHexString(PublicKey publicKey) {
        BCECPublicKey key = (BCECPublicKey)publicKey;
        byte[] encodedKey = key.getQ().getEncoded(false);
        return Hex.toHexString((byte[])encodedKey);
    }

    public static String getPubKeyBase64String(PublicKey publicKey) {
        return new String(Base64.getEncoder().encode(publicKey.getEncoded()));
    }

    public static String encrypt(String data, PublicKey publicKey) {
        return SM2Utils.encrypt((byte[])data.getBytes(StandardCharsets.UTF_8), (PublicKey)publicKey);
    }

    public static String encrypt(byte[] data, PublicKey publicKey) {
        BCECPublicKey key = (BCECPublicKey)publicKey;
        return SM2Utils.encrypt((byte[])data, (String)Hex.toHexString((byte[])key.getQ().getEncoded(false)));
    }

    public static String encrypt(String data, String pubKeyHexString) {
        return SM2Utils.encrypt((byte[])data.getBytes(StandardCharsets.UTF_8), (String)pubKeyHexString);
    }

    public static String encrypt(byte[] data, String pubKeyHexString) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPoint pukPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)pubKeyHexString));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            arrayOfBytes = sm2Engine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            System.out.println("SM2\u52a0\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
        }
        return Hex.toHexString((byte[])arrayOfBytes);
    }

    public static String decrypt(String cipherData, PrivateKey privateKey) {
        return SM2Utils.decrypt((byte[])Hex.decode((String)cipherData), (PrivateKey)privateKey);
    }

    public static String decrypt(byte[] cipherData, PrivateKey privateKey) {
        BCECPrivateKey key = (BCECPrivateKey)privateKey;
        return SM2Utils.decrypt((byte[])cipherData, (String)Hex.toHexString((byte[])key.getD().toByteArray()));
    }

    public static String decrypt(String cipherData, String priKeyHexString) {
        if (!((String)cipherData).startsWith("04")) {
            cipherData = "04" + (String)cipherData;
        }
        return SM2Utils.decrypt((byte[])Hex.decode((String)cipherData), (String)priKeyHexString);
    }

    public static String decrypt(byte[] cipherData, String priKeyHexString) {
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        BigInteger privateKeyD = new BigInteger(priKeyHexString, 16);
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine(SM2Engine.Mode.C1C3C2);
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        String result = "";
        try {
            byte[] arrayOfBytes = sm2Engine.processBlock(cipherData, 0, cipherData.length);
            return new String(arrayOfBytes);
        }
        catch (Exception e) {
            System.out.println("SM2\u89e3\u5bc6\u65f6\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            return result;
        }
    }

    public static String sign(String data, String priKeyHexString) throws Exception {
        return SM2Utils.sign((byte[])data.getBytes(StandardCharsets.UTF_8), (String)priKeyHexString);
    }

    public static String sign(byte[] data, String priKeyHexString) throws Exception {
        String signValue = null;
        SM2Signer signer = new SM2Signer();
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ParametersWithRandom param = new ParametersWithRandom((CipherParameters)new ECPrivateKeyParameters(new BigInteger(priKeyHexString, 16), domainParameters));
        signer.init(true, (CipherParameters)param);
        signer.update(data, 0, data.length);
        signValue = Hex.toHexString((byte[])signer.generateSignature());
        return signValue;
    }

    public static boolean verify(String data, String signValue, String publicKeyHexString) throws Exception {
        return SM2Utils.verify((byte[])data.getBytes(StandardCharsets.UTF_8), (byte[])Hex.decode((String)signValue), (String)publicKeyHexString);
    }

    public static boolean verify(byte[] data, byte[] sign, String publicKeyHexString) throws Exception {
        SM2Signer signer = new SM2Signer();
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        if (((String)publicKeyHexString).length() == 128) {
            publicKeyHexString = "04" + (String)publicKeyHexString;
        }
        ECPoint ecPoint = sm2ECParameters.getCurve().decodePoint(Hex.decode((String)publicKeyHexString));
        ECPublicKeyParameters param = new ECPublicKeyParameters(ecPoint, domainParameters);
        signer.init(false, (CipherParameters)param);
        signer.update(data, 0, data.length);
        return signer.verifySignature(sign);
    }

    public static String getPubKeyByPriKey(String priKeyHexString) throws Exception {
        if (priKeyHexString == null || priKeyHexString.length() != 64) {
            System.err.println("priKey \u5fc5\u987b\u662fHex 64\u4f4d\u683c\u5f0f\uff0c\u4f8b\u5982\uff1a11d0a44d47449d48d614f753ded6b06af76033b9c3a2af2b8b2239374ccbce3a");
            return "";
        }
        String pubKeyHexString = null;
        X9ECParameters sm2ECParameters = GMNamedCurves.getByName((String)"sm2p256v1");
        BigInteger privateKeyD = new BigInteger(priKeyHexString, 16);
        ECParameterSpec ecParameterSpec = new ECParameterSpec(sm2ECParameters.getCurve(), sm2ECParameters.getG(), sm2ECParameters.getN());
        ECPrivateKeySpec ecPrivateKeySpec = new ECPrivateKeySpec(privateKeyD, ecParameterSpec);
        PrivateKey privateKey = null;
        privateKey = KeyFactory.getInstance("EC", (Provider)new BouncyCastleProvider()).generatePrivate((KeySpec)ecPrivateKeySpec);
        String pointString = privateKey.toString();
        String pointString_X = pointString.substring(pointString.indexOf("X: ") + "X: ".length(), pointString.indexOf("Y: ")).trim();
        String pointString_Y = pointString.substring(pointString.indexOf("Y: ") + "Y: ".length()).trim();
        pubKeyHexString = "04" + pointString_X + pointString_Y;
        return pubKeyHexString;
    }

    public static void main(String[] args) throws Exception {
        String s1 = "{\"a\":\"123\",\"b\":5}";
        Sm2SendData sendObj = new Sm2SendData();
        SendDataOrigin sendDataOrigin = new SendDataOrigin();
        sendDataOrigin.setJson(s1);
        sendDataOrigin.setSchoolCode("001");
        sendObj.setSendDataOrigin(sendDataOrigin);
        String s = JSON.toJSONString((Object)sendObj);
        System.out.println("======  sm2\u6d4b\u8bd5  ======");
        System.out.println("begin \u5f00\u59cb\u751f\u6210\u5bc6\u94a5\u5bf9>>>");
        KeyPair keyPair = SM2Utils.geneSM2KeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String pubKeyHexString = SM2Utils.getPubKeyHexString((PublicKey)publicKey);
        System.out.println("\u516c\u94a5\t" + pubKeyHexString);
        PrivateKey privateKey = keyPair.getPrivate();
        String priKeyHexString = SM2Utils.getPriKeyHexString((PrivateKey)privateKey);
        System.out.println("\u79c1\u94a5\t" + priKeyHexString);
        System.out.println("end   \u7ed3\u675f\u751f\u6210\u5bc6\u94a5\u5bf9>>>");
        System.out.println("begin  \u670d\u52a1\u5668A\u5f00\u59cb>>>");
        System.out.println("A\u7684\u539f\u59cb\u6570\u636e\t" + s);
        String priKeyHexStringA = "53796db25a1979bf218b2372945eaf63822ff01efa9b9c664aea8ca63f6fb118";
        String signA = SM2Utils.sign((String)s, (String)priKeyHexStringA);
        System.out.println("A\u7684\u6570\u5b57\u7b7e\u540d\t" + signA);
        sendObj.setSign(signA);
        String pubKeyHexStringB = "0423100fa792033c4eba474f92570b0393dab862b136227a5d6b43c7c13f0c92afd794a717b460c73513c5f019f612e9efbb9a4115794e73b76aad1368d2e26e37";
        String cipherData = SM2Utils.encrypt((String)JSON.toJSONString((Object)sendObj), (String)pubKeyHexStringB);
        System.out.println("A\u7684\u5bc6\u6587\t" + cipherData);
        System.out.println("end  \u670d\u52a1\u5668A\u7ed3\u675f>>>");
        System.out.println("begin  \u670d\u52a1\u5668B\u5f00\u59cb>>>");
        String priKeyHexStringB = "bba3b603d30fe9bd290818dcb80a8cc6b5d3e1d481284bb4c61592f3bc3b639f";
        String json = SM2Utils.decrypt((String)cipherData, (String)priKeyHexStringB);
        System.out.println("B\u89e3\u5bc6A\u7684\u5bc6\u6587,\u5f97\u5230\u539f\u59cbdata\u548c\u6570\u5b57\u7b7e\u540d\t" + json);
        Sm2SendData map1 = (Sm2SendData)JSON.parseObject((String)json, Sm2SendData.class);
        String pubKeyHexStringA = "040de9df6124ed4c56c02f2c28a9ab4df0cec034fd1cd223ba7c275af82675eedbad186491b702d517b0d7682640ffb5f19de5f49bd334ea132463b90f9d748474";
        boolean verifyResult = SM2Utils.verify((String)JSON.toJSONString((Object)map1.getSendDataOrigin()), (String)map1.getSign(), (String)pubKeyHexStringA);
        System.out.println("B\u5bf9A\u7684\u9a8c\u7b7e\u7ed3\u679c\t" + verifyResult);
        System.out.println("B\u83b7\u5f97A\u7684\u539f\u59cb\u6570\u636e\t" + JSON.toJSONString((Object)map1.getSendDataOrigin()));
        System.out.println("end  \u670d\u52a1\u5668B\u7ed3\u675f>>>");
    }
}

