/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.wmf.WmfParser;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public class Wmf2PngUtil {
    public static void wmfToSvg(InputStream in, String dest) throws Exception {
        boolean compatible = false;
        WmfParser parser = new WmfParser();
        SvgGdi gdi = new SvgGdi(compatible);
        parser.parse(in, (Gdi)gdi);
        Document doc = gdi.getDocument();
        OutputStream out = new FileOutputStream(dest);
        if (dest.endsWith(".svgz")) {
            out = new GZIPOutputStream(out);
        }
        Wmf2PngUtil.output((Document)doc, (OutputStream)out);
    }

    public static void svgToPng(File svg, String pngFile) throws Exception {
        FileInputStream wmfStream = new FileInputStream(svg);
        ByteArrayOutputStream imageOut = new ByteArrayOutputStream();
        int noOfByteRead = 0;
        while ((noOfByteRead = wmfStream.read()) != -1) {
            imageOut.write(noOfByteRead);
        }
        imageOut.flush();
        imageOut.close();
        wmfStream.close();
        ByteArrayOutputStream jpg = new ByteArrayOutputStream();
        FileOutputStream jpgOut = new FileOutputStream(pngFile);
        byte[] bytes = imageOut.toByteArray();
        PNGTranscoder t = new PNGTranscoder();
        TranscoderInput in = new TranscoderInput((InputStream)new ByteArrayInputStream(bytes));
        TranscoderOutput out = new TranscoderOutput((OutputStream)jpg);
        t.transcode(in, out);
        jpgOut.write(jpg.toByteArray());
        jpgOut.flush();
        jpgOut.close();
        imageOut = null;
        jpgOut = null;
    }

    private static void output(Document doc, OutputStream out) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD SVG 1.0//EN");
        transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        transformer.transform(new DOMSource(doc), new StreamResult(out));
        out.flush();
        out.close();
        out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void PreprocessSvgFile(String svgFile) throws Exception {
        int defaultWeight = 500;
        FileInputStream inputs = new FileInputStream(svgFile);
        Scanner sc = new Scanner((InputStream)inputs, "UTF-8");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while (sc.hasNextLine()) {
            String ln = sc.nextLine();
            if (ln.startsWith("<!DOCTYPE")) continue;
            os.write((ln + "\r\n").getBytes());
        }
        os.flush();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = null;
        try {
            doc = builder.parse(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (Exception e) {
            inputs = new FileInputStream(svgFile);
            os = new ByteArrayOutputStream();
            int noOfByteRead = 0;
            while ((noOfByteRead = inputs.read()) != -1) {
                os.write(noOfByteRead);
            }
            os.flush();
            doc = builder.parse(new ByteArrayInputStream(os.toByteArray()));
        }
        finally {
            os.close();
            inputs.close();
        }
        int height = Integer.parseInt(((Element)doc.getElementsByTagName("svg").item(0)).getAttribute("height"));
        int width = Integer.parseInt(((Element)doc.getElementsByTagName("svg").item(0)).getAttribute("width"));
        int newHeight = 0;
        int newWidth = 0;
        newHeight = height / 10;
        newWidth = width / 10;
        if (newWidth > defaultWeight) {
            newWidth = defaultWeight;
            newHeight = defaultWeight * height / width;
        }
        ((Element)doc.getElementsByTagName("svg").item(0)).setAttribute("width", String.valueOf(newWidth));
        ((Element)doc.getElementsByTagName("svg").item(0)).setAttribute("height", String.valueOf(newHeight));
        FileOutputStream out = new FileOutputStream(svgFile);
        Wmf2PngUtil.output((Document)doc, (OutputStream)out);
    }
}

