/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util.socket;

import com.zsy.exam.util.socket.ResultVo;
import com.zsy.exam.util.socket.SessionBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class ZsyWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(ZsyWebSocketHandler.class);
    public static Map<String, SessionBean> map = new ConcurrentHashMap();
    private static AtomicInteger clientIdMaker = new AtomicInteger(0);

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        Long userId = 0L;
        super.afterConnectionEstablished(session);
        String[] split = session.getUri().getQuery().split("=");
        if (split[0].toLowerCase().equals("userid")) {
            userId = Long.valueOf(split[1]);
        }
        SessionBean sessionBean = new SessionBean(session, userId);
        map.put(session.getId(), sessionBean);
        log.info(session.getId() + "\u5efa\u7acb\u4e86\u8fde\u63a5");
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        super.handleTextMessage(session, message);
        log.info(String.valueOf(map.get(session.getId())) + ":" + (String)message.getPayload());
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        super.afterConnectionClosed(session, status);
        map.remove(session.getId());
        log.info(session.getId() + "\u5173\u95ed\u8fde\u63a5");
    }

    public static void sendMessageForUserMap(Object message) {
        ResultVo resultVo = (ResultVo)message;
        List list = (List)resultVo.getMessage();
        for (SessionBean sessionBean : map.values()) {
            try {
                for (Map map : list) {
                    WebSocketSession webSocketSession;
                    if (!sessionBean.getUserId().equals(map.get("userId")) || null == (webSocketSession = sessionBean.getWebSocketSession())) continue;
                    webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)map.get("count").toString()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

