/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.util.tree;

import com.zsy.exam.util.tree.BaseTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TreeNodeBuilder {
    public static <T extends BaseTreeNode> List<T> getParentList(List<T> listNodes, String id) {
        if (!StringUtils.hasText((String)id) || CollectionUtils.isEmpty(listNodes)) {
            return null;
        }
        ArrayList<BaseTreeNode> treeNodes = new ArrayList<BaseTreeNode>();
        int length = listNodes.size();
        byte[] nodeIndex = new byte[length];
        for (int i = 0; i < length; ++i) {
            BaseTreeNode t = (BaseTreeNode)listNodes.get(i);
            if (!id.equals(t.getId()) || nodeIndex[i] != 0) continue;
            nodeIndex[i] = 1;
            treeNodes.add(t);
            id = t.getPId();
            if (!StringUtils.hasText((String)id) || "null".equals(id) || "0".equals(id)) break;
            i = -1;
        }
        return treeNodes;
    }

    public static <T extends BaseTreeNode> List<T> getChildList(List<T> listNodes, List<String> ids) {
        return CollectionUtils.isEmpty(ids) ? null : TreeNodeBuilder.getChildList(listNodes, (String[])ids.toArray(new String[ids.size()]));
    }

    public static <T extends BaseTreeNode> List<T> getChildList(List<T> listNodes, String id) {
        return !StringUtils.hasText((String)id) ? null : TreeNodeBuilder.getChildList(listNodes, (String[])new String[]{id});
    }

    public static <T extends BaseTreeNode> List<T> getChildList(List<T> listNodes, String[] ids) {
        BaseTreeNode t;
        if (ids == null || ids.length == 0 || CollectionUtils.isEmpty(listNodes)) {
            return null;
        }
        ArrayList<BaseTreeNode> treeNodes = new ArrayList<BaseTreeNode>();
        int length = listNodes.size();
        byte[] nodeIndex = new byte[length];
        for (String id : ids) {
            for (int i = 0; i < length; ++i) {
                t = (BaseTreeNode)listNodes.get(i);
                if (!id.equals(t.getId())) continue;
                treeNodes.add(t);
                nodeIndex[i] = 1;
            }
        }
        for (int index = 0; index < treeNodes.size(); ++index) {
            String tempId = ((BaseTreeNode)treeNodes.get(index)).getId();
            if (!StringUtils.hasText((String)tempId)) continue;
            for (int i = 0; i < length; ++i) {
                t = (BaseTreeNode)listNodes.get(i);
                if (!tempId.equals(t.getPId()) || nodeIndex[i] != 0) continue;
                nodeIndex[i] = 1;
                treeNodes.add(t);
            }
        }
        return treeNodes;
    }

    public static <T extends BaseTreeNode> List<T> assembleTree(List<T> listNodes) {
        ArrayList newTreeNodes = new ArrayList();
        newTreeNodes.addAll(listNodes.stream().filter(t -> !StringUtils.hasText((String)t.getPId()) || "null".equals(t.getPId()) || "0".equals(t.getId())).collect(Collectors.toList()));
        for (BaseTreeNode t2 : newTreeNodes) {
            TreeNodeBuilder.assembleTree((BaseTreeNode)t2, listNodes);
        }
        return newTreeNodes;
    }

    public static <T extends BaseTreeNode> T assembleTreeById(String id, List<T> listNodes) {
        if (!StringUtils.hasText((String)id) || CollectionUtils.isEmpty(listNodes)) {
            return null;
        }
        BaseTreeNode node = null;
        for (BaseTreeNode temp : listNodes) {
            if (!id.equals(temp.getId())) continue;
            node = temp;
            break;
        }
        TreeNodeBuilder.assembleTree(node, listNodes);
        return (T)node;
    }

    static <T extends BaseTreeNode> void assembleTree(T node, List<T> listNodes) {
        if (node != null && !CollectionUtils.isEmpty(listNodes)) {
            listNodes.stream().filter(t -> Objects.equals(t.getPId(), node.getId())).forEachOrdered(arg_0 -> node.addChild(arg_0));
            if (!CollectionUtils.isEmpty((Collection)node.getChild())) {
                for (Object t2 : node.getChild()) {
                    TreeNodeBuilder.assembleTree((BaseTreeNode)((BaseTreeNode)t2), listNodes);
                }
            }
        }
    }

    public static <T extends BaseTreeNode> String idToString(List<T> treeNodes) {
        return TreeNodeBuilder.idToString(treeNodes, (String)",");
    }

    public static <T extends BaseTreeNode> String idToString(List<T> treeNodes, String c) {
        StringBuilder pks = new StringBuilder();
        if (treeNodes != null) {
            for (BaseTreeNode t : treeNodes) {
                pks.append(t.getId()).append(c);
            }
        }
        return pks.length() > 0 ? pks.delete(pks.length() - c.length(), pks.length()).toString() : "";
    }
}

