package ${package.Controller};

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import ${package.Entity}.${entity};
import ${package.Service}.${table.serviceName};
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
<#--import org.apache.shiro.authz.annotation.Logical;-->
<#--import org.apache.shiro.authz.annotation.RequiresPermissions;-->
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.Valid;
import java.util.List;
<#--import com.common.res.DataResult;-->
<#if restControllerStyle>
<#else>
    import org.springframework.stereotype.Controller;
</#if>
<#if superControllerClassPackage??>
    import ${superControllerClassPackage};
</#if>
/**
* @author ${author}
* @since ${date}
*/
<#if restControllerStyle>
    @RestController
<#else>
    @Controller
</#if>
@Tag(name = "${controllerMappingHyphen}", description = "${table.comment!}")
@RequestMapping("/api/<#if controllerMappingHyphenStyle>${controllerMappingHyphen}<#else>${table.entityPath}</#if>")
<#if kotlin>
    class ${table.controllerName}<#if superControllerClass??> : ${superControllerClass}()</#if>
<#else>
    <#if superControllerClass??>
        public class ${table.controllerName} extends ${superControllerClass} {
    <#else>
        public class ${table.controllerName} {
    </#if>

    @Autowired
    private ${table.serviceName} ${table.serviceName?substring(1)?uncap_first};


    @GetMapping("/selectOne")
<#--    @RequiresPermissions("sys:${table.entityName?uncap_first}:list")-->
    @Operation(summary = "${table.comment!}查询单个")
    @PreAuthorize("hasAnyAuthority('role_teacher','role_admin')")
    public Result<${table.entityName}> get${table.entityName}(@RequestParam("id") Long id){
    ${table.entityName} ${table.entityName?uncap_first}One = ${table.entityName?uncap_first}Service.get${table.entityName}( id);
    return  Result.success(${table.entityName?uncap_first}One);
    }

    @GetMapping("/listAll")
<#--    @RequiresPermissions("sys:${table.entityName?uncap_first}:list")-->
    @Operation(summary = "${table.comment!}查询全部")
    @PreAuthorize("hasAnyAuthority('role_teacher','role_admin')")
    public Result<Page<${table.entityName}>> getAll${table.entityName}(Page page){
    Page<${table.entityName}> ${table.entityName?uncap_first}List = ${table.entityName?uncap_first}Service.getAll${table.entityName}(page);
    return  Result.success(${table.entityName?uncap_first}List);
    }

    @PostMapping("/add")
<#--    @RequiresPermissions("sys:${table.entityName?uncap_first}:add")-->
    @Operation(summary = "${table.comment!}新增")
    @PreAuthorize("hasAnyAuthority('role_teacher','role_admin')")
    public Result add(@Valid @RequestBody ${table.entityName} ${table.entityName?uncap_first}) {
    ${table.entityName?uncap_first}Service.add( ${table.entityName?uncap_first});
    return Result.success();
    }

    @PutMapping("/update")
<#--    @RequiresPermissions("sys:${table.entityName?uncap_first}:update")-->
    @Operation(summary = "${table.comment!}修改")
    @PreAuthorize("hasAnyAuthority('role_teacher','role_admin')")
    public Result<Integer> update(@Valid @RequestBody ${table.entityName} ${table.entityName?uncap_first}) {
    Integer num = ${table.entityName?uncap_first}Service.modify( ${table.entityName?uncap_first});
    return Result.success(num);
    }


    @DeleteMapping(value = "/delete/{ids}")
<#--    @RequiresPermissions("sys:${table.entityName?uncap_first}:delete")-->
    @Operation(summary = "${table.comment!}删除(多个条目，使用逗号分隔)")
    @PreAuthorize("hasAnyAuthority('role_teacher','role_admin')")
    public Result remove(@NotBlank(message = "{required}") @PathVariable String ids) {
    ${table.entityName?uncap_first}Service.remove(ids);
    return Result.success();
    }
    }
</#if>